/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.script;

import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.validation.script.TemplateBasedScriptBuilder;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyObject;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class GroovyAction
extends AbstractTestAction {
    private String script;
    private String scriptResourcePath;
    private String scriptTemplate;
    private String scriptTemplatePath = "classpath:com/consol/citrus/script/script-template.groovy";
    private boolean useScriptTemplate = true;
    private static Logger log = LoggerFactory.getLogger(GroovyAction.class);

    public GroovyAction() {
        this.setName("groovy");
    }

    @Override
    public void doExecute(TestContext context) {
        try {
            GroovyClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<GroovyClassLoader>(){

                @Override
                public GroovyClassLoader run() {
                    ClassLoader parent = this.getClass().getClassLoader();
                    return new GroovyClassLoader(parent);
                }
            });
            this.assertScriptProvided();
            String rawCode = StringUtils.hasText((String)this.script) ? this.script.trim() : FileUtils.readToString(FileUtils.getFileResource(this.scriptResourcePath, context));
            String code = context.replaceDynamicContentInString(rawCode.trim());
            Class groovyClass = loader.parseClass(code);
            GroovyObject groovyObject = (GroovyObject)groovyClass.newInstance();
            if (this.useScriptTemplate && groovyObject.getClass().getSimpleName().startsWith("script")) {
                code = StringUtils.hasText((String)this.scriptTemplate) ? TemplateBasedScriptBuilder.fromTemplateScript(context.replaceDynamicContentInString(this.scriptTemplate)).withCode(code).build() : TemplateBasedScriptBuilder.fromTemplateResource(FileUtils.getFileResource(this.scriptTemplatePath, context)).withCode(code).build();
                groovyClass = loader.parseClass(code);
                groovyObject = (GroovyObject)groovyClass.newInstance();
            }
            if (log.isDebugEnabled()) {
                log.debug("Executing Groovy script:\n" + code);
            }
            if (groovyObject instanceof ScriptExecutor) {
                ((ScriptExecutor)groovyObject).execute(context);
            } else {
                groovyObject.invokeMethod("run", (Object)new Object[0]);
            }
            log.info("Groovy script execution successful");
        }
        catch (CitrusRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new CitrusRuntimeException(e);
        }
    }

    private void assertScriptProvided() {
        if (!StringUtils.hasText((String)this.script) && this.scriptResourcePath == null) {
            throw new CitrusRuntimeException("Neither inline script nor external script resource is defined. Unable to execute groovy script.");
        }
    }

    public void setScript(String script) {
        this.script = script;
    }

    public String getScript() {
        return this.script;
    }

    public String getScriptResourcePath() {
        return this.scriptResourcePath;
    }

    public void setScriptResourcePath(String fileResource) {
        this.scriptResourcePath = fileResource;
    }

    public void setScriptTemplate(String scriptTemplate) {
        this.scriptTemplate = scriptTemplate;
    }

    public void setScriptTemplatePath(String scriptTemplate) {
        this.scriptTemplatePath = scriptTemplate;
    }

    public void setUseScriptTemplate(boolean useScriptTemplate) {
        this.useScriptTemplate = useScriptTemplate;
    }

    public boolean isUseScriptTemplate() {
        return this.useScriptTemplate;
    }

    public String getScriptTemplatePath() {
        return this.scriptTemplatePath;
    }

    public String getScriptTemplate() {
        return this.scriptTemplate;
    }

    public static interface ScriptExecutor {
        public void execute(TestContext var1);
    }
}

