/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.TestCase;
import com.consol.citrus.report.TestListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TestListeners {
    @Autowired
    private List<TestListener> testListeners = new ArrayList<TestListener>();

    public void onTestFailure(TestCase test, Throwable cause) {
        for (TestListener listener : this.testListeners) {
            listener.onTestFailure(test, cause);
        }
    }

    public void onTestFinish(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestFinish(test);
        }
    }

    public void onTestSkipped(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestSkipped(test);
        }
    }

    public void onTestStart(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestStart(test);
        }
    }

    public void onTestSuccess(TestCase test) {
        for (TestListener listener : this.testListeners) {
            listener.onTestSuccess(test);
        }
    }

    public void addTestListener(TestListener listener) {
        if (!this.testListeners.contains(listener)) {
            this.testListeners.add(listener);
        }
    }
}

