/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.report.TestActionListener;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class TestActionListeners {
    @Autowired(required=false)
    private List<TestActionListener> testActionListeners = new ArrayList<TestActionListener>();

    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        for (TestActionListener listener : this.testActionListeners) {
            listener.onTestActionFinish(testCase, testAction);
        }
    }

    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
        for (TestActionListener listener : this.testActionListeners) {
            listener.onTestActionSkipped(testCase, testAction);
        }
    }

    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        for (TestActionListener listener : this.testActionListeners) {
            listener.onTestActionStart(testCase, testAction);
        }
    }

    public void addTestActionListener(TestActionListener listener) {
        this.testActionListeners.add(listener);
    }
}

