/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.report.AbstractOutputFileReporter;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.util.PropertyUtils;
import java.io.IOException;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class SummaryReporter
extends AbstractOutputFileReporter {
    @Value(value="${citrus.summary.report.enabled:true}")
    private String enabled = Boolean.TRUE.toString();
    @Value(value="${citrus.summary.report.file:citrus-summary.xml}")
    private String reportFileName = "citrus-summary.xml";
    @Value(value="${citrus.summary.report.template:classpath:com/consol/citrus/report/summary-report.xml}")
    private String reportTemplate = "classpath:com/consol/citrus/report/summary-report.xml";

    @Override
    protected String getReportContent() {
        try {
            Properties reportProps = new Properties();
            reportProps.put("test.cnt", Integer.toString(this.getTestResults().getSize()));
            reportProps.put("skipped.test.cnt", Integer.toString(this.getTestResults().getSkipped()));
            reportProps.put("skipped.test.pct", this.getTestResults().getSkippedPercentage());
            reportProps.put("failed.test.cnt", Integer.toString(this.getTestResults().getFailed()));
            reportProps.put("failed.test.pct", this.getTestResults().getFailedPercentage());
            reportProps.put("success.test.cnt", Integer.toString(this.getTestResults().getSuccess()));
            reportProps.put("success.test.pct", this.getTestResults().getSuccessPercentage());
            return PropertyUtils.replacePropertiesInString(FileUtils.readToString(FileUtils.getFileResource(this.reportTemplate)), reportProps);
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to generate summary test report", e);
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = String.valueOf(enabled);
    }

    @Override
    protected boolean isEnabled() {
        return StringUtils.hasText((String)this.enabled) && this.enabled.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public void setReportFileName(String reportFileName) {
        this.reportFileName = reportFileName;
    }

    @Override
    public String getReportFileName() {
        return this.reportFileName;
    }
}

