/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.TestCase;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.RawMessage;
import com.consol.citrus.report.AbstractTestListener;
import com.consol.citrus.report.MessageListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Value;

public class MessageTracingTestListener
extends AbstractTestListener
implements InitializingBean,
MessageListener {
    private static final String TRACE_FILE_ENDING = ".msgs";
    private static final Date TEST_EXECUTION_DATE = new Date();
    @Value(value="${citrus.message.trace.directory:target/citrus-logs/trace/messages}")
    private String outputDirectory;
    private final List<String> messages = new ArrayList<String>();
    private final Object lockObject = new Object();
    private static final Logger LOG = LoggerFactory.getLogger(MessageTracingTestListener.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestStart(TestCase test) {
        Object object = this.lockObject;
        synchronized (object) {
            this.messages.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onTestFinish(TestCase test) {
        if (this.messages.isEmpty()) {
            return;
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.getTraceFile(test.getName())));){
            writer.write(this.separator() + this.newLine() + this.newLine());
            Object object = this.lockObject;
            synchronized (object) {
                for (String message : this.messages) {
                    writer.write(message);
                    writer.write(this.newLine() + this.separator() + this.newLine() + this.newLine());
                }
            }
            writer.flush();
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to write message trace to filesystem", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onInboundMessage(Message message, TestContext context) {
        if (message instanceof RawMessage) {
            Object object = this.lockObject;
            synchronized (object) {
                this.messages.add("INBOUND_MESSAGE:" + this.newLine() + this.newLine() + message);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onOutboundMessage(Message message, TestContext context) {
        if (message instanceof RawMessage) {
            Object object = this.lockObject;
            synchronized (object) {
                this.messages.add("OUTBOUND_MESSAGE:" + this.newLine() + this.newLine() + message);
            }
        }
    }

    private String separator() {
        return "======================================================================";
    }

    private String newLine() {
        return System.getProperty("line.separator");
    }

    public void afterPropertiesSet() throws Exception {
        File targetDirectory = new File(this.outputDirectory);
        if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create message tracing output directory: " + this.outputDirectory);
        }
    }

    protected File getTraceFile(String testName) {
        String testExecutionStartTime = new SimpleDateFormat("yyyyMMdd_HHmmss").format(TEST_EXECUTION_DATE);
        String filename = String.format("%s_%s%s", testName, testExecutionStartTime, TRACE_FILE_ENDING);
        File traceFile = new File(this.outputDirectory, filename);
        if (traceFile.exists()) {
            LOG.warn(String.format("Trace file '%s' already exists. Normally a new file is created on each test execution ", traceFile.getName()));
        }
        return traceFile;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }
}

