/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestAction;
import com.consol.citrus.TestCase;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.message.Message;
import com.consol.citrus.report.AbstractTestReporter;
import com.consol.citrus.report.MessageListener;
import com.consol.citrus.report.TestActionListener;
import com.consol.citrus.report.TestListener;
import com.consol.citrus.report.TestReporter;
import com.consol.citrus.report.TestSuiteListener;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class LoggingReporter
extends AbstractTestReporter
implements MessageListener,
TestSuiteListener,
TestListener,
TestActionListener,
TestReporter {
    private static Logger inboundMsgLogger = LoggerFactory.getLogger((String)"Logger.Message_IN");
    private static Logger outboundMsgLogger = LoggerFactory.getLogger((String)"Logger.Message_OUT");
    private static Logger log = LoggerFactory.getLogger(LoggingReporter.class);

    @Override
    public void generateTestResults() {
        this.separator();
        this.newLine();
        this.info("CITRUS TEST RESULTS");
        this.newLine();
        this.getTestResults().doWithResults(testResult -> {
            this.info(testResult.toString());
            if (testResult.isFailed()) {
                this.info(Optional.ofNullable(testResult.getCause()).filter(cause -> StringUtils.hasText((String)cause.getMessage())).map(cause -> " FAILURE: Caused by: " + cause.getClass().getSimpleName() + ": " + cause.getMessage()).orElse(" FAILURE: Caused by: " + Optional.ofNullable(testResult.getErrorMessage()).orElse("Unknown error")));
            }
        });
        this.newLine();
        this.info("TOTAL:\t" + (this.getTestResults().getFailed() + this.getTestResults().getSuccess()));
        this.debug("SKIPPED:\t" + this.getTestResults().getSkipped() + " (" + this.getTestResults().getSkippedPercentage() + "%)");
        this.info("FAILED:\t" + this.getTestResults().getFailed() + " (" + this.getTestResults().getFailedPercentage() + "%)");
        this.info("SUCCESS:\t" + this.getTestResults().getSuccess() + " (" + this.getTestResults().getSuccessPercentage() + "%)");
        this.newLine();
        this.separator();
    }

    @Override
    public void onTestFailure(TestCase test, Throwable cause) {
        super.onTestFailure(test, cause);
        this.newLine();
        this.error("TEST FAILED " + test.getName() + " <" + test.getPackageName() + "> Nested exception is: ", cause);
        this.separator();
        this.newLine();
    }

    @Override
    public void onTestSkipped(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("SKIPPING TEST: " + test.getName());
            this.separator();
            this.newLine();
        }
        super.onTestSkipped(test);
    }

    @Override
    public void onTestStart(TestCase test) {
        if (this.isDebugEnabled()) {
            this.newLine();
            this.separator();
            this.debug("STARTING TEST " + test.getName() + " <" + test.getPackageName() + ">");
            this.newLine();
        }
    }

    @Override
    public void onTestSuccess(TestCase test) {
        super.onTestSuccess(test);
        this.newLine();
        this.info("TEST SUCCESS " + test.getName() + " (" + test.getPackageName() + ")");
        this.separator();
        this.newLine();
    }

    @Override
    public void onFinish() {
        super.onFinish();
        this.newLine();
        this.separator();
        this.debug("AFTER TEST SUITE");
        this.newLine();
    }

    @Override
    public void onStart() {
        super.onStart();
        this.newLine();
        this.separator();
        this.info("       .__  __                       ");
        this.info("  ____ |__|/  |________ __ __  ______");
        this.info("_/ ___\\|  \\   __\\_  __ \\  |  \\/  ___/");
        this.info("\\  \\___|  ||  |  |  | \\/  |  /\\___ \\ ");
        this.info(" \\___  >__||__|  |__|  |____//____  >");
        this.info("     \\/                           \\/");
        this.newLine();
        this.info("C I T R U S  T E S T S  " + Citrus.getVersion());
        this.newLine();
        this.separator();
        this.debug("BEFORE TEST SUITE");
        this.newLine();
    }

    @Override
    public void onFinishFailure(Throwable cause) {
        this.newLine();
        this.info("AFTER TEST SUITE: FAILED");
        this.separator();
        this.newLine();
        super.onFinishFailure(cause);
    }

    @Override
    public void onFinishSuccess() {
        this.newLine();
        this.info("AFTER TEST SUITE: SUCCESS");
        this.separator();
        this.newLine();
        super.onFinishSuccess();
    }

    @Override
    public void onStartFailure(Throwable cause) {
        super.onStartFailure(cause);
        this.newLine();
        this.info("BEFORE TEST SUITE: FAILED");
        this.separator();
        this.newLine();
    }

    @Override
    public void onStartSuccess() {
        super.onStartSuccess();
        this.newLine();
        this.info("BEFORE TEST SUITE: SUCCESS");
        this.separator();
        this.newLine();
    }

    @Override
    public void onTestActionStart(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isTestRunner()) {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + ": " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()));
            }
            if (testAction instanceof TestActionContainer) {
                this.debug("TEST ACTION CONTAINER with " + ((TestActionContainer)testAction).getActionCount() + " embedded actions");
            }
            if (StringUtils.hasText((String)testAction.getDescription())) {
                this.debug("");
                this.debug(testAction.getDescription());
                this.debug("");
            }
        }
    }

    @Override
    public void onTestActionFinish(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isTestRunner()) {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + " SUCCESS");
            } else {
                this.debug("TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount() + " SUCCESS");
            }
        }
    }

    @Override
    public void onTestActionSkipped(TestCase testCase, TestAction testAction) {
        if (this.isDebugEnabled()) {
            this.newLine();
            if (testCase.isTestRunner()) {
                this.debug("SKIPPING TEST STEP " + (testCase.getActionIndex(testAction) + 1));
            } else {
                this.debug("SKIPPING TEST STEP " + (testCase.getActionIndex(testAction) + 1) + "/" + testCase.getActionCount());
            }
            this.debug("TEST ACTION " + (testAction.getName() != null ? testAction.getName() : testAction.getClass().getName()) + " SKIPPED");
        }
    }

    @Override
    public void onInboundMessage(Message message, TestContext context) {
        inboundMsgLogger.debug(message.toString());
    }

    @Override
    public void onOutboundMessage(Message message, TestContext context) {
        outboundMsgLogger.debug(message.toString());
    }

    private void separator() {
        this.info("------------------------------------------------------------------------");
    }

    private void newLine() {
        this.info("");
    }

    protected void info(String line) {
        log.info(line);
    }

    protected void error(String line, Throwable cause) {
        log.error(line, cause);
    }

    protected void debug(String line) {
        if (this.isDebugEnabled()) {
            log.debug(line);
        }
    }

    protected boolean isDebugEnabled() {
        return log.isDebugEnabled();
    }
}

