/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.TestResult;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.report.AbstractTestReporter;
import com.consol.citrus.util.FileUtils;
import com.consol.citrus.util.PropertyUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class JUnitReporter
extends AbstractTestReporter {
    private static Logger log = LoggerFactory.getLogger(JUnitReporter.class);
    @Value(value="${citrus.junit.report.directory:junitreports}")
    private String outputDirectory = "junitreports";
    @Value(value="${citrus.junit.report.file.pattern:TEST-%s.xml}")
    private String reportFileNamePattern = "TEST-%s.xml";
    @Value(value="${citrus.junit.report.suite.name:TestSuite}")
    private String suiteName = "TestSuite";
    @Value(value="${citrus.junit.report.template:classpath:com/consol/citrus/report/junit-report.xml}")
    private String reportTemplate = "classpath:com/consol/citrus/report/junit-report.xml";
    @Value(value="${citrus.junit.report.success.template:classpath:com/consol/citrus/report/junit-test.xml}")
    private String successTemplate = "classpath:com/consol/citrus/report/junit-test.xml";
    @Value(value="${citrus.junit.report.failed.template:classpath:com/consol/citrus/report/junit-test-failed.xml}")
    private String failedTemplate = "classpath:com/consol/citrus/report/junit-test-failed.xml";
    @Value(value="${citrus.junit.report.enabled:true}")
    private String enabled = Boolean.TRUE.toString();

    @Override
    public void generateTestResults() {
        if (this.isEnabled()) {
            ReportTemplates reportTemplates = new ReportTemplates();
            log.debug("Generating JUnit test report");
            try {
                List<TestResult> results = this.getTestResults().asList();
                this.createReportFile(String.format(this.reportFileNamePattern, this.suiteName), this.createReportContent(this.suiteName, results, reportTemplates), new File(this.getReportDirectory()));
                HashMap groupedResults = new HashMap();
                for (TestResult result : results) {
                    if (!groupedResults.containsKey(result.getClassName())) {
                        groupedResults.put(result.getClassName(), new ArrayList());
                    }
                    ((List)groupedResults.get(result.getClassName())).add(result);
                }
                File targetDirectory = new File(this.getReportDirectory() + (StringUtils.hasText((String)this.outputDirectory) ? File.separator + this.outputDirectory : ""));
                for (Map.Entry resultEntry : groupedResults.entrySet()) {
                    this.createReportFile(String.format(this.reportFileNamePattern, resultEntry.getKey()), this.createReportContent((String)resultEntry.getKey(), (List)resultEntry.getValue(), reportTemplates), targetDirectory);
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to generate JUnit test report", e);
            }
        }
    }

    private String createReportContent(String suiteName, List<TestResult> results, ReportTemplates templates) throws IOException {
        StringBuilder reportDetails = new StringBuilder();
        for (TestResult result : results) {
            Properties detailProps = new Properties();
            detailProps.put("test.class", result.getClassName());
            detailProps.put("test.name", result.getTestName());
            detailProps.put("test.duration", "0.0");
            if (result.isFailed()) {
                detailProps.put("test.error.cause", Optional.ofNullable(result.getCause()).map(Object::getClass).map(Class::getName).orElse(result.getFailureType()));
                detailProps.put("test.error.msg", result.getErrorMessage());
                detailProps.put("test.error.stackTrace", Optional.ofNullable(result.getCause()).map(cause -> {
                    StringWriter writer = new StringWriter();
                    cause.printStackTrace(new PrintWriter(writer));
                    return writer.toString();
                }).orElse(result.getFailureStack()));
                reportDetails.append(PropertyUtils.replacePropertiesInString(templates.getFailedTemplate(), detailProps));
                continue;
            }
            reportDetails.append(PropertyUtils.replacePropertiesInString(templates.getSuccessTemplate(), detailProps));
        }
        Properties reportProps = new Properties();
        reportProps.put("test.suite", suiteName);
        reportProps.put("test.cnt", Integer.toString(results.size()));
        reportProps.put("test.skipped.cnt", Long.toString(results.stream().filter(TestResult::isSkipped).count()));
        reportProps.put("test.failed.cnt", Long.toString(results.stream().filter(TestResult::isFailed).count()));
        reportProps.put("test.success.cnt", Long.toString(results.stream().filter(TestResult::isSuccess).count()));
        reportProps.put("test.error.cnt", "0");
        reportProps.put("test.duration", "0.0");
        reportProps.put("tests", reportDetails.toString());
        return PropertyUtils.replacePropertiesInString(templates.getReportTemplate(), reportProps);
    }

    private void createReportFile(String reportFileName, String content, File targetDirectory) {
        if (!targetDirectory.exists() && !targetDirectory.mkdirs()) {
            throw new CitrusRuntimeException("Unable to create report output directory: " + this.getReportDirectory() + (StringUtils.hasText((String)this.outputDirectory) ? "/" + this.outputDirectory : ""));
        }
        try (FileWriter fileWriter = new FileWriter(new File(targetDirectory, reportFileName));){
            ((Writer)fileWriter).append(content);
            ((Writer)fileWriter).flush();
        }
        catch (IOException e) {
            log.error("Failed to create test report", (Throwable)e);
        }
    }

    public String getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(String outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getReportFileNamePattern() {
        return this.reportFileNamePattern;
    }

    public void setReportFileNamePattern(String reportFileNamePattern) {
        this.reportFileNamePattern = reportFileNamePattern;
    }

    public String getReportTemplate() {
        return this.reportTemplate;
    }

    public void setReportTemplate(String reportTemplate) {
        this.reportTemplate = reportTemplate;
    }

    public String getSuiteName() {
        return this.suiteName;
    }

    public void setSuiteName(String suiteName) {
        this.suiteName = suiteName;
    }

    public String getSuccessTemplate() {
        return this.successTemplate;
    }

    public void setSuccessTemplate(String successTemplate) {
        this.successTemplate = successTemplate;
    }

    public String getFailedTemplate() {
        return this.failedTemplate;
    }

    public void setFailedTemplate(String failedTemplate) {
        this.failedTemplate = failedTemplate;
    }

    public boolean isEnabled() {
        return StringUtils.hasText((String)this.enabled) && this.enabled.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public void setEnabled(boolean enabled) {
        this.enabled = String.valueOf(enabled);
    }

    private class ReportTemplates {
        private String reportTemplateContent;
        private String successTemplateContent;
        private String failedTemplateContent;

        private ReportTemplates() {
        }

        public String getReportTemplate() throws IOException {
            if (this.reportTemplateContent == null) {
                this.reportTemplateContent = FileUtils.readToString(FileUtils.getFileResource(JUnitReporter.this.reportTemplate));
            }
            return this.reportTemplateContent;
        }

        public String getSuccessTemplate() throws IOException {
            if (this.successTemplateContent == null) {
                this.successTemplateContent = FileUtils.readToString(FileUtils.getFileResource(JUnitReporter.this.successTemplate));
            }
            return this.successTemplateContent;
        }

        public String getFailedTemplate() throws IOException {
            if (this.failedTemplateContent == null) {
                this.failedTemplateContent = FileUtils.readToString(FileUtils.getFileResource(JUnitReporter.this.failedTemplate));
            }
            return this.failedTemplateContent;
        }
    }
}

