/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.report;

import com.consol.citrus.TestCase;
import com.consol.citrus.TestResult;
import com.consol.citrus.report.AbstractTestListener;
import com.consol.citrus.report.TestListener;
import com.consol.citrus.report.TestReporter;
import com.consol.citrus.report.TestResults;
import com.consol.citrus.report.TestSuiteListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public abstract class AbstractTestReporter
extends AbstractTestListener
implements TestReporter,
TestListener,
TestSuiteListener {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    @Value(value="${citrus.report.directory:target/citrus-reports}")
    private String reportDirectory = "target/citrus-reports";
    @Value(value="${citrus.report.auto.clear:true}")
    private String autoClear = Boolean.TRUE.toString();
    @Value(value="${citrus.report.ignore.errors:true}")
    private String ignoreErrors = Boolean.TRUE.toString();
    private TestResults testResults = new TestResults();

    @Override
    public void clearTestResults() {
        this.testResults = new TestResults();
    }

    public TestResults getTestResults() {
        return this.testResults;
    }

    private void createTestReport() {
        try {
            this.generateTestResults();
        }
        catch (Exception e) {
            if (this.isIgnoreErrors()) {
                this.log.error("Failed to create test report", (Throwable)e);
            }
            throw e;
        }
    }

    @Override
    public void onStart() {
        if (this.isAutoClear()) {
            this.clearTestResults();
        }
    }

    @Override
    public void onFinish() {
    }

    @Override
    public void onFinishFailure(Throwable cause) {
        this.createTestReport();
    }

    @Override
    public void onFinishSuccess() {
        this.createTestReport();
    }

    @Override
    public void onStartFailure(Throwable cause) {
    }

    @Override
    public void onStartSuccess() {
    }

    @Override
    public void onTestSuccess(TestCase test) {
        this.testResults.addResult(TestResult.success(test.getName(), test.getTestClass().getName()));
    }

    @Override
    public void onTestFailure(TestCase test, Throwable cause) {
        this.testResults.addResult(TestResult.failed(test.getName(), test.getTestClass().getName(), cause));
    }

    @Override
    public void onTestSkipped(TestCase test) {
        this.testResults.addResult(TestResult.skipped(test.getName(), test.getTestClass().getName()));
    }

    public String getReportDirectory() {
        return this.reportDirectory;
    }

    public void setReportDirectory(String reportDirectory) {
        this.reportDirectory = reportDirectory;
    }

    public boolean isAutoClear() {
        return StringUtils.hasText((String)this.autoClear) && this.autoClear.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public void setAutoClear(boolean autoClear) {
        this.autoClear = String.valueOf(autoClear);
    }

    public boolean isIgnoreErrors() {
        return StringUtils.hasText((String)this.ignoreErrors) && this.ignoreErrors.equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public void setIgnoreErrors(boolean ignoreErrors) {
        this.ignoreErrors = String.valueOf(ignoreErrors);
    }
}

