/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.message;

import com.consol.citrus.message.Message;
import java.util.Map;

public final class MessageHeaderUtils {
    private MessageHeaderUtils() {
    }

    public static boolean isSpringInternalHeader(String headerName) {
        if (headerName.startsWith("springintegration_")) {
            return true;
        }
        if (headerName.equals("id")) {
            return true;
        }
        if (headerName.equals("timestamp")) {
            return true;
        }
        if (headerName.equals("replyChannel")) {
            return true;
        }
        if (headerName.equals("errorChannel")) {
            return true;
        }
        if (headerName.equals("contentType")) {
            return true;
        }
        if (headerName.equals("priority")) {
            return true;
        }
        if (headerName.equals("correlationId")) {
            return true;
        }
        if (headerName.equals("routingSlip")) {
            return true;
        }
        if (headerName.equals("duplicateMessage")) {
            return true;
        }
        if (headerName.equals("sequenceNumber")) {
            return true;
        }
        if (headerName.equals("sequenceSize")) {
            return true;
        }
        if (headerName.equals("sequenceDetails")) {
            return true;
        }
        if (headerName.equals("expirationDate")) {
            return true;
        }
        return headerName.startsWith("jms_");
    }

    public static void setHeader(Message message, String name, String value) {
        if (name.equals("sequenceNumber")) {
            message.setHeader("sequenceNumber", Integer.valueOf(value));
        } else if (name.equals("sequenceSize")) {
            message.setHeader("sequenceSize", Integer.valueOf(value));
        } else if (name.equals("priority")) {
            message.setHeader("priority", Integer.valueOf(value));
        } else {
            message.setHeader(name, value);
        }
    }

    public static void checkHeaderTypes(Map<String, Object> headers) {
        String size;
        if (headers.containsKey("sequenceNumber")) {
            String number = headers.get("sequenceNumber").toString();
            headers.put("sequenceNumber", Integer.valueOf(number));
        }
        if (headers.containsKey("sequenceSize")) {
            size = headers.get("sequenceSize").toString();
            headers.put("sequenceSize", Integer.valueOf(size));
        }
        if (headers.containsKey("priority")) {
            size = headers.get("priority").toString();
            headers.put("priority", Integer.valueOf(size));
        }
    }
}

