/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.main.scan;

import com.consol.citrus.TestClass;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.main.scan.AbstractTestScanner;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public class JarFileTestScanner
extends AbstractTestScanner {
    private static Logger log = LoggerFactory.getLogger(JarFileTestScanner.class);
    private final File artifact;

    public JarFileTestScanner(File artifact, String ... includes) {
        super(includes);
        this.artifact = artifact;
    }

    @Override
    public List<TestClass> findTestsInPackage(String packageToScan) {
        ArrayList<TestClass> testClasses = new ArrayList<TestClass>();
        if (this.artifact != null && this.artifact.isFile()) {
            try (JarFile jar = new JarFile(this.artifact);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String className = StringUtils.removeEnd((String)entry.getName(), (String)".class").replace("/", ".");
                    if (!new AntPathMatcher().matchStart(packageToScan.replace(".", "/"), entry.getName()) || !this.isIncluded(className)) continue;
                    log.info("Found test class candidate in test jar file: " + entry.getName());
                    testClasses.add(new TestClass(className));
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Failed to access jar file artifact", e);
            }
        }
        return testClasses;
    }
}

