/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.junit.jupiter;

import com.consol.citrus.Citrus;
import com.consol.citrus.TestCase;
import com.consol.citrus.annotations.CitrusAnnotations;
import com.consol.citrus.annotations.CitrusResource;
import com.consol.citrus.annotations.CitrusXmlTest;
import com.consol.citrus.common.TestLoader;
import com.consol.citrus.common.XmlTestLoader;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.stream.Stream;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeAllCallback;
import org.junit.jupiter.api.extension.BeforeEachCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstancePostProcessor;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class CitrusBaseExtension
implements BeforeAllCallback,
BeforeEachCallback,
BeforeTestExecutionCallback,
AfterTestExecutionCallback,
ParameterResolver,
TestInstancePostProcessor {
    private static final String SUITE_NAME = "citrus-junit5-suite";
    private static Citrus citrus;
    private static boolean beforeSuite;
    private static boolean afterSuite;
    protected static final ExtensionContext.Namespace NAMESPACE;

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusBaseExtension.getBaseKey(extensionContext) + TestContext.class.getSimpleName()));
        extensionContext.getRoot().getStore(NAMESPACE).remove((Object)(CitrusBaseExtension.getBaseKey(extensionContext) + TestCase.class.getSimpleName()));
    }

    public void beforeAll(ExtensionContext extensionContext) throws Exception {
        if (beforeSuite) {
            beforeSuite = false;
            CitrusBaseExtension.getCitrus(extensionContext).beforeSuite(SUITE_NAME, new String[0]);
        }
        if (afterSuite) {
            afterSuite = false;
            Runtime.getRuntime().addShutdownHook(new Thread(() -> CitrusBaseExtension.getCitrus(extensionContext).afterSuite(SUITE_NAME, new String[0])));
        }
    }

    public void beforeEach(ExtensionContext extensionContext) throws Exception {
        CitrusBaseExtension.getTestContext(extensionContext);
        CitrusBaseExtension.getXmlTestCase(extensionContext);
    }

    public void beforeTestExecution(ExtensionContext extensionContext) throws Exception {
        CitrusBaseExtension.getCitrus(extensionContext).run(CitrusBaseExtension.getXmlTestCase(extensionContext), CitrusBaseExtension.getTestContext(extensionContext));
    }

    public void postProcessTestInstance(Object testInstance, ExtensionContext extensionContext) throws Exception {
        CitrusAnnotations.injectAll(testInstance, CitrusBaseExtension.getCitrus(extensionContext));
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().isAnnotationPresent(CitrusResource.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        if (TestContext.class.isAssignableFrom(parameterContext.getParameter().getType())) {
            return CitrusBaseExtension.getTestContext(extensionContext);
        }
        throw new CitrusRuntimeException(String.format("Failed to resolve parameter %s", parameterContext.getParameter()));
    }

    protected static String getBaseKey(ExtensionContext extensionContext) {
        return extensionContext.getRequiredTestClass().getName() + "." + extensionContext.getRequiredTestMethod().getName() + "#";
    }

    protected static TestLoader createTestLoader(ExtensionContext extensionContext) {
        Method method = extensionContext.getRequiredTestMethod();
        String testName = extensionContext.getRequiredTestClass().getSimpleName();
        String packageName = method.getDeclaringClass().getPackage().getName();
        if (method.getAnnotation(CitrusXmlTest.class) != null) {
            CitrusXmlTest citrusXmlTestAnnotation = method.getAnnotation(CitrusXmlTest.class);
            String[] packagesToScan = citrusXmlTestAnnotation.packageScan();
            if (StringUtils.hasText((String)citrusXmlTestAnnotation.packageName())) {
                packageName = citrusXmlTestAnnotation.packageName();
            }
            if (citrusXmlTestAnnotation.name().length > 0) {
                testName = citrusXmlTestAnnotation.name()[0];
            } else if (packagesToScan.length == 0) {
                testName = method.getName();
            }
        }
        return new XmlTestLoader(extensionContext.getRequiredTestClass(), testName, packageName, CitrusBaseExtension.getCitrus(extensionContext).getApplicationContext());
    }

    protected static Citrus getCitrus(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (Citrus)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)Citrus.class.getName(), key -> {
            if (citrus == null) {
                citrus = Citrus.newInstance();
            }
            return citrus;
        }, Citrus.class);
    }

    protected static TestContext getTestContext(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestContext)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusBaseExtension.getBaseKey(extensionContext) + TestContext.class.getSimpleName()), key -> CitrusBaseExtension.getCitrus(extensionContext).createTestContext(), TestContext.class);
    }

    protected static TestCase getXmlTestCase(ExtensionContext extensionContext) {
        Assert.notNull((Object)extensionContext, (String)"ExtensionContext must not be null");
        return (TestCase)extensionContext.getRoot().getStore(NAMESPACE).getOrComputeIfAbsent((Object)(CitrusBaseExtension.getBaseKey(extensionContext) + TestCase.class.getSimpleName()), key -> CitrusBaseExtension.createTestLoader(extensionContext).load(), TestCase.class);
    }

    public static Stream<DynamicTest> packageScan(String ... packagesToScan) {
        ArrayList<DynamicTest> tests = new ArrayList<DynamicTest>();
        for (String packageScan : packagesToScan) {
            try {
                for (String fileNamePattern : Citrus.getXmlTestFileNamePattern()) {
                    Resource[] fileResources;
                    for (Resource fileResource : fileResources = new PathMatchingResourcePatternResolver().getResources(packageScan.replace('.', File.separatorChar) + fileNamePattern)) {
                        String filePath = fileResource.getFile().getParentFile().getCanonicalPath();
                        if (packageScan.startsWith("file:")) {
                            filePath = "file:" + filePath;
                        }
                        filePath = filePath.substring(filePath.indexOf(packageScan.replace('.', File.separatorChar)));
                        String testName = fileResource.getFilename().substring(0, fileResource.getFilename().length() - ".xml".length());
                        XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, filePath, citrus.getApplicationContext());
                        tests.add(DynamicTest.dynamicTest((String)testName, () -> citrus.run(testLoader.load())));
                    }
                }
            }
            catch (IOException e) {
                throw new CitrusRuntimeException("Unable to locate file resources for test package '" + packageScan + "'", e);
            }
        }
        return tests.stream();
    }

    public static Stream<DynamicTest> dynamicTests(String packageName, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, (String)testName, packageName, citrus.getApplicationContext());
            return DynamicTest.dynamicTest((String)testName, () -> citrus.run(testLoader.load()));
        });
    }

    public static Stream<DynamicTest> dynamicTests(Class<?> testClass, String ... testNames) {
        return Stream.of(testNames).map(testName -> {
            XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, (String)testName, testClass.getPackage().getName(), citrus.getApplicationContext());
            return DynamicTest.dynamicTest((String)testName, () -> citrus.run(testLoader.load()));
        });
    }

    public static DynamicTest dynamicTest(String packageName, String testName) {
        XmlTestLoader testLoader = new XmlTestLoader(DynamicTest.class, testName, packageName, citrus.getApplicationContext());
        return DynamicTest.dynamicTest((String)testName, () -> citrus.run(testLoader.load()));
    }

    static {
        beforeSuite = true;
        afterSuite = true;
        NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{CitrusBaseExtension.class});
    }
}

