/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import com.consol.citrus.util.XMLUtils;
import com.consol.citrus.xml.xpath.XPathUtils;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import org.springframework.util.CollectionUtils;
import org.springframework.xml.namespace.SimpleNamespaceContext;

public class XpathFunction
implements Function {
    @Override
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        if (parameterList.size() < 2) {
            throw new InvalidFunctionUsageException("Missing parameter for function - usage xpath('xmlSource', 'expression')");
        }
        String xmlSource = parameterList.get(0);
        String xpathExpression = parameterList.get(1);
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.setBindings(context.getNamespaceContextBuilder().getNamespaceMappings());
        return XPathUtils.evaluateAsString(XMLUtils.parseMessagePayload(context.replaceDynamicContentInString(xmlSource)), context.replaceDynamicContentInString(xpathExpression), (NamespaceContext)namespaceContext);
    }
}

