/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import com.consol.citrus.util.FileUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.CollectionUtils;
import org.springframework.util.FileCopyUtils;

public class ReadFileResourceFunction
implements Function {
    @Override
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Missing file path function parameter");
        }
        boolean base64 = parameterList.size() > 1 ? Boolean.valueOf(parameterList.get(1)) : false;
        try {
            if (base64) {
                return Base64.encodeBase64String((byte[])FileCopyUtils.copyToByteArray((InputStream)FileUtils.getFileResource(parameterList.get(0), context).getInputStream()));
            }
            return context.replaceDynamicContentInString(FileUtils.readToString(FileUtils.getFileResource(parameterList.get(0), context), FileUtils.getCharset(parameterList.get(0))));
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to read file", e);
        }
    }
}

