/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import java.util.List;
import java.util.Random;
import org.springframework.util.CollectionUtils;

public class RandomNumberFunction
implements Function {
    private static Random generator = new Random(System.currentTimeMillis());

    @Override
    public String execute(List<String> parameterList, TestContext context) {
        boolean paddingOn = true;
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        if (parameterList.size() > 2) {
            throw new InvalidFunctionUsageException("Too many parameters for function");
        }
        int numberLength = Integer.valueOf(parameterList.get(0));
        if (numberLength < 0) {
            throw new InvalidFunctionUsageException("Invalid parameter definition. Number of letters must not be positive non-zero integer value");
        }
        if (parameterList.size() > 1) {
            paddingOn = Boolean.valueOf(parameterList.get(1));
        }
        return RandomNumberFunction.getRandomNumber(numberLength, paddingOn);
    }

    public static String getRandomNumber(int numberLength, boolean paddingOn) {
        if (numberLength < 1) {
            throw new InvalidFunctionUsageException("numberLength must be greater than 0 - supplied " + numberLength);
        }
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < numberLength; ++i) {
            buffer.append(generator.nextInt(10));
        }
        return RandomNumberFunction.checkLeadingZeros(buffer.toString(), paddingOn);
    }

    public static String checkLeadingZeros(String generated, boolean paddingOn) {
        if (paddingOn) {
            return RandomNumberFunction.replaceLeadingZero(generated);
        }
        return RandomNumberFunction.removeLeadingZeros(generated);
    }

    private static String removeLeadingZeros(String generated) {
        StringBuilder builder = new StringBuilder();
        boolean leading = true;
        for (int i = 0; i < generated.length(); ++i) {
            if (generated.charAt(i) == '0' && leading) continue;
            leading = false;
            builder.append(generated.charAt(i));
        }
        if (builder.length() == 0) {
            builder.append('0');
        }
        return builder.toString();
    }

    private static String replaceLeadingZero(String generated) {
        if (generated.charAt(0) == '0') {
            int replacement = 0;
            while (replacement == 0) {
                replacement = generator.nextInt(10);
            }
            return replacement + generated.substring(1);
        }
        return generated;
    }
}

