/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import java.util.List;
import java.util.Random;

public class RandomEnumValueFunction
implements Function {
    private Random random = new Random(System.currentTimeMillis());
    private List<String> values = null;

    @Override
    public String execute(List<String> params, TestContext context) {
        if (this.values == null) {
            return this.randomValue(params);
        }
        if (!params.isEmpty()) {
            throw new InvalidFunctionUsageException("The enumeration values have already been set");
        }
        return this.randomValue(this.values);
    }

    protected String randomValue(List<String> values) {
        if (values == null || values.isEmpty()) {
            throw new InvalidFunctionUsageException("No values to choose from");
        }
        int idx = this.random.nextInt(values.size());
        return values.get(idx);
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }
}

