/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class MapValueFunction
implements Function,
InitializingBean {
    private Map<String, String> map = null;

    @Override
    public String execute(List<String> params, TestContext context) {
        if (params.size() != 1) {
            throw new InvalidFunctionUsageException("Expected exactly one argument but got " + params.size());
        }
        String key = params.get(0);
        String result = this.map.get(key);
        if (result == null) {
            throw new InvalidFunctionUsageException("No mapping found for \"" + key + "\"");
        }
        return result;
    }

    public void afterPropertiesSet() {
        Assert.notEmpty(this.map);
    }

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setMap(Map<String, String> map) {
        this.map = map;
    }
}

