/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import com.consol.citrus.message.Message;
import java.util.List;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LoadMessageFunction
implements Function {
    @Override
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Function parameters must not be empty");
        }
        String messageName = parameterList.get(0);
        String messageHeader = null;
        if (messageName.endsWith(".payload()")) {
            messageName = messageName.substring(0, messageName.indexOf(".payload()"));
        } else if (messageName.contains(".header(") && messageName.endsWith(")")) {
            messageHeader = messageName.substring(messageName.indexOf(".header(") + 8, messageName.length() - 1);
            if (messageHeader.startsWith("'") && messageHeader.endsWith("'")) {
                messageHeader = messageHeader.substring(1, messageHeader.length() - 1);
            }
            if (!StringUtils.hasText((String)messageHeader)) {
                throw new CitrusRuntimeException("Missing header name in function parameter");
            }
            messageName = messageName.substring(0, messageName.indexOf(".header("));
        }
        Message stored = context.getMessageStore().getMessage(messageName);
        if (stored == null) {
            throw new CitrusRuntimeException(String.format("Failed to find stored message of name: '%s'", messageName));
        }
        if (StringUtils.hasText(messageHeader)) {
            Object headerValue = stored.getHeader(messageHeader);
            if (headerValue == null) {
                throw new CitrusRuntimeException(String.format("Failed to find header '%s' in stored message", messageHeader));
            }
            return headerValue.toString();
        }
        return stored.getPayload(String.class);
    }
}

