/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import java.util.List;
import java.util.Optional;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.util.CollectionUtils;

public class EnvironmentPropertyFunction
implements Function,
EnvironmentAware {
    private Environment environment;

    @Override
    public String execute(List<String> parameterList, TestContext context) {
        if (CollectionUtils.isEmpty(parameterList)) {
            throw new InvalidFunctionUsageException("Invalid function parameters - must set environment property name");
        }
        String propertyName = parameterList.get(0);
        Optional<Object> defaultValue = parameterList.size() > 1 ? Optional.of(parameterList.get(1)) : Optional.empty();
        return Optional.ofNullable(this.environment.getProperty(propertyName)).orElseGet(() -> (String)defaultValue.orElseThrow(() -> new CitrusRuntimeException(String.format("Failed to resolve property '%s' in environment", propertyName))));
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }
}

