/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions.core;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.InvalidFunctionUsageException;
import com.consol.citrus.functions.Function;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;

public class DigestAuthHeaderFunction
implements Function {
    private Long nonceValidity = 60000L;

    @Override
    public String execute(List<String> parameterList, TestContext context) {
        if (parameterList == null || parameterList.size() < 8) {
            throw new InvalidFunctionUsageException("Function parameters not set correctly - need parameters: username,password,realm,noncekey,method,uri,opaque,algorithm");
        }
        StringBuilder authorizationHeader = new StringBuilder();
        String username = parameterList.get(0);
        String password = parameterList.get(1);
        String realm = parameterList.get(2);
        String noncekey = parameterList.get(3);
        String method = parameterList.get(4);
        String uri = parameterList.get(5);
        String opaque = parameterList.get(6);
        String algorithm = parameterList.get(7);
        String digest1 = username + ":" + realm + ":" + password;
        String digest2 = method + ":" + uri;
        Long expirationTime = System.currentTimeMillis() + this.nonceValidity;
        String nonce = Base64.encodeBase64String((byte[])(expirationTime + ":" + this.getDigestHex(algorithm, expirationTime + ":" + noncekey)).getBytes());
        authorizationHeader.append("Digest username=");
        authorizationHeader.append(username);
        authorizationHeader.append(",realm=");
        authorizationHeader.append(realm);
        authorizationHeader.append(",nonce=");
        authorizationHeader.append(nonce);
        authorizationHeader.append(",uri=");
        authorizationHeader.append(uri);
        authorizationHeader.append(",response=");
        authorizationHeader.append(this.getDigestHex(algorithm, this.getDigestHex(algorithm, digest1) + ":" + nonce + ":" + this.getDigestHex(algorithm, digest2)));
        authorizationHeader.append(",opaque=");
        authorizationHeader.append(this.getDigestHex(algorithm, opaque));
        authorizationHeader.append(",algorithm=");
        authorizationHeader.append(algorithm);
        return authorizationHeader.toString();
    }

    private String getDigestHex(String algorithm, String key) {
        if (algorithm.equals("md5")) {
            return DigestUtils.md5Hex((String)key);
        }
        if (algorithm.equals("sha")) {
            return DigestUtils.shaHex((String)key);
        }
        throw new CitrusRuntimeException("Unsupported digest algorithm: " + algorithm);
    }

    public void setNonceValidity(Long nonceValidity) {
        this.nonceValidity = nonceValidity;
    }
}

