/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.functions;

import com.consol.citrus.exceptions.NoSuchFunctionLibraryException;
import com.consol.citrus.functions.FunctionLibrary;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class FunctionRegistry {
    @Autowired
    private List<FunctionLibrary> functionLibraries = new ArrayList<FunctionLibrary>();

    public boolean isFunction(String variableExpression) {
        if (variableExpression == null || variableExpression.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.functionLibraries.size(); ++i) {
            FunctionLibrary lib = this.functionLibraries.get(i);
            if (!variableExpression.startsWith(lib.getPrefix())) continue;
            return true;
        }
        return false;
    }

    public FunctionLibrary getLibraryForPrefix(String functionPrefix) {
        for (int i = 0; i < this.functionLibraries.size(); ++i) {
            if (!this.functionLibraries.get(i).getPrefix().equals(functionPrefix)) continue;
            return this.functionLibraries.get(i);
        }
        throw new NoSuchFunctionLibraryException("Can not find function library for prefix " + functionPrefix);
    }

    public void setFunctionLibraries(List<FunctionLibrary> functionLibraries) {
        this.functionLibraries = functionLibraries;
    }

    public List<FunctionLibrary> getFunctionLibraries() {
        return this.functionLibraries;
    }
}

