/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint.adapter;

import com.consol.citrus.TestCase;
import com.consol.citrus.channel.ChannelEndpointAdapter;
import com.consol.citrus.channel.ChannelSyncEndpointConfiguration;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.endpoint.adapter.RequestDispatchingEndpointAdapter;
import com.consol.citrus.endpoint.adapter.mapping.BeanNameMappingStrategy;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.message.Message;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.core.task.TaskExecutor;

public class XmlTestExecutingEndpointAdapter
extends RequestDispatchingEndpointAdapter
implements InitializingBean,
BeanNameAware,
ApplicationContextAware {
    private TaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
    private String name = EndpointAdapter.class.getSimpleName();
    private ApplicationContext applicationContext;
    @Autowired
    private TestContextFactory testContextFactory;
    private EndpointAdapter endpointAdapterDelegate;
    private String packageName = "com.consol.citrus.tests";

    @Override
    public Message dispatchMessage(final Message request, String mappingName) {
        TestCase test;
        TestContext testContext;
        try {
            testContext = this.testContextFactory.getObject();
            test = this.getTestCase(testContext, mappingName);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException("Unable to find test builder with name '" + mappingName + "' in Spring bean context", e);
        }
        this.taskExecutor.execute(new Runnable(){

            @Override
            public void run() {
                XmlTestExecutingEndpointAdapter.this.prepareExecution(request, test);
                test.execute(testContext);
            }
        });
        return this.endpointAdapterDelegate.handleMessage(request);
    }

    protected TestCase getTestCase(TestContext context, String testName) {
        ClassPathXmlApplicationContext ctx = this.createApplicationContext(context, this.packageName, testName);
        try {
            TestCase testCase = (TestCase)ctx.getBean(testName, TestCase.class);
            testCase.setName(testName);
            testCase.setPackageName(this.packageName);
            return testCase;
        }
        catch (NoSuchBeanDefinitionException e) {
            throw context.handleError(testName, this.packageName, "Could not find test with name '" + testName + "'", (Exception)((Object)e));
        }
    }

    protected ClassPathXmlApplicationContext createApplicationContext(TestContext context, String packageName, String testName) {
        try {
            return new ClassPathXmlApplicationContext(new String[]{packageName.replace('.', '/') + "/" + testName + ".xml", "com/consol/citrus/spring/annotation-config-ctx.xml"}, true, this.applicationContext);
        }
        catch (Exception e) {
            throw context.handleError(this.getClass().getSimpleName(), this.getClass().getPackage().getName(), "Failed to load test case", e);
        }
    }

    protected void prepareExecution(Message request, TestCase testCase) {
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        if (this.endpointAdapterDelegate == null) {
            ChannelSyncEndpointConfiguration endpointConfiguration = new ChannelSyncEndpointConfiguration();
            endpointConfiguration.setChannelName(this.name + ".inbound");
            endpointConfiguration.setBeanFactory((BeanFactory)this.applicationContext);
            ChannelEndpointAdapter channelEndpointAdapter = new ChannelEndpointAdapter(endpointConfiguration);
            channelEndpointAdapter.setTestContextFactory(this.testContextFactory);
            this.endpointAdapterDelegate = channelEndpointAdapter;
        }
        if (this.getMappingStrategy() == null) {
            BeanNameMappingStrategy mappingStrategy = new BeanNameMappingStrategy();
            mappingStrategy.setApplicationContext(this.applicationContext);
            this.setMappingStrategy(mappingStrategy);
        }
    }

    @Override
    public void setBeanName(String name) {
        this.name = name;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public TaskExecutor getTaskExecutor() {
        return this.taskExecutor;
    }

    public void setTaskExecutor(TaskExecutor taskExecutor) {
        this.taskExecutor = taskExecutor;
    }

    public EndpointAdapter getResponseEndpointAdapter() {
        return this.endpointAdapterDelegate;
    }

    public void setResponseEndpointAdapter(EndpointAdapter endpointAdapterDelegate) {
        this.endpointAdapterDelegate = endpointAdapterDelegate;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

