/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.TestActor;
import com.consol.citrus.annotations.CitrusEndpoint;
import com.consol.citrus.annotations.CitrusEndpointProperty;
import com.consol.citrus.endpoint.Endpoint;
import com.consol.citrus.endpoint.EndpointBuilder;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.util.TypeConversionUtils;
import java.lang.reflect.Method;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

public abstract class AbstractEndpointBuilder<T extends Endpoint>
implements EndpointBuilder<T> {
    public AbstractEndpointBuilder<T> name(String endpointName) {
        this.getEndpoint().setName(endpointName);
        return this;
    }

    public AbstractEndpointBuilder<T> actor(TestActor actor) {
        this.getEndpoint().setActor(actor);
        return this;
    }

    public AbstractEndpointBuilder<T> initialize() {
        if (this.getEndpoint() instanceof InitializingBean) {
            try {
                ((InitializingBean)this.getEndpoint()).afterPropertiesSet();
            }
            catch (Exception e) {
                throw new CitrusRuntimeException("Failed to initialize endpoint", e);
            }
        }
        return this;
    }

    public AbstractEndpointBuilder<T> applicationContext(ApplicationContext applicationContext) {
        if (this.getEndpoint() instanceof ApplicationContextAware) {
            ((ApplicationContextAware)this.getEndpoint()).setApplicationContext(applicationContext);
        }
        if (this.getEndpoint() instanceof BeanFactoryAware) {
            ((BeanFactoryAware)this.getEndpoint()).setBeanFactory((BeanFactory)applicationContext);
        }
        return this;
    }

    @Override
    public T build(CitrusEndpoint endpointAnnotation) {
        ReflectionUtils.invokeMethod((Method)ReflectionUtils.findMethod(this.getClass(), (String)"name"), (Object)this, (Object[])new Object[]{endpointAnnotation.name()});
        for (CitrusEndpointProperty endpointProperty : endpointAnnotation.properties()) {
            Method propertyMethod = ReflectionUtils.findMethod(this.getClass(), (String)endpointProperty.name());
            if (propertyMethod == null) continue;
            ReflectionUtils.invokeMethod((Method)propertyMethod, (Object)this, (Object[])new Object[]{TypeConversionUtils.convertStringToType(endpointProperty.value(), endpointProperty.type())});
        }
        return this.build();
    }

    @Override
    public T build() {
        return this.getEndpoint();
    }

    protected abstract T getEndpoint();
}

