/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.endpoint;

import com.consol.citrus.context.TestContext;
import com.consol.citrus.context.TestContextFactory;
import com.consol.citrus.endpoint.EndpointAdapter;
import com.consol.citrus.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class AbstractEndpointAdapter
implements EndpointAdapter,
BeanNameAware,
InitializingBean,
ApplicationContextAware {
    private EndpointAdapter fallbackEndpointAdapter = null;
    private String name = this.getClass().getSimpleName();
    private ApplicationContext applicationContext;
    @Autowired(required=false)
    private TestContextFactory testContextFactory;
    protected Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public final Message handleMessage(Message request) {
        Message replyMessage = this.handleMessageInternal(request);
        if (replyMessage == null || replyMessage.getPayload() == null) {
            if (this.fallbackEndpointAdapter != null) {
                this.log.debug("Did not receive reply message - delegating to fallback endpoint adapter");
                replyMessage = this.fallbackEndpointAdapter.handleMessage(request);
            } else {
                this.log.debug("Did not receive reply message - no response is simulated");
            }
        }
        return replyMessage;
    }

    protected abstract Message handleMessageInternal(Message var1);

    public void afterPropertiesSet() throws Exception {
        if (this.testContextFactory == null) {
            this.log.warn("Could not identify proper test context factory from Spring bean application context - constructing own test context factory. This restricts test context capabilities to an absolute minimum! You could do better when enabling the root application context for this server instance.");
            this.testContextFactory = TestContextFactory.newInstance(this.applicationContext);
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public EndpointAdapter getFallbackEndpointAdapter() {
        return this.fallbackEndpointAdapter;
    }

    public void setFallbackEndpointAdapter(EndpointAdapter fallbackEndpointAdapter) {
        this.fallbackEndpointAdapter = fallbackEndpointAdapter;
    }

    public void setTestContextFactory(TestContextFactory testContextFactory) {
        this.testContextFactory = testContextFactory;
    }

    public TestContextFactory getTestContextFactory() {
        return this.testContextFactory;
    }

    protected TestContext getTestContext() {
        return this.testContextFactory.getObject();
    }
}

