/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.context.SpringBeanReferenceResolver;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.endpoint.DefaultEndpointFactory;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.interceptor.GlobalMessageConstructionInterceptors;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.CollectionUtils;

public class TestContextFactory
implements FactoryBean<TestContext>,
ApplicationContextAware {
    @Autowired
    private FunctionRegistry functionRegistry;
    @Autowired
    private ValidationMatcherRegistry validationMatcherRegistry;
    @Autowired(required=false)
    private GlobalVariables globalVariables = new GlobalVariables();
    @Autowired
    private MessageValidatorRegistry messageValidatorRegistry;
    @Autowired
    private TestListeners testListeners;
    @Autowired
    private MessageListeners messageListeners;
    @Autowired
    private EndpointFactory endpointFactory;
    @Autowired
    private ReferenceResolver referenceResolver;
    @Autowired
    private GlobalMessageConstructionInterceptors globalMessageConstructionInterceptors;
    @Autowired(required=false)
    private NamespaceContextBuilder namespaceContextBuilder;
    private ApplicationContext applicationContext;
    private static Logger log = LoggerFactory.getLogger(TestContextFactory.class);

    public static TestContextFactory newInstance() {
        TestContextFactory factory = new TestContextFactory();
        factory.setFunctionRegistry(new FunctionRegistry());
        factory.setValidationMatcherRegistry(new ValidationMatcherRegistry());
        factory.setGlobalVariables(new GlobalVariables());
        factory.setMessageValidatorRegistry(new MessageValidatorRegistry());
        factory.setTestListeners(new TestListeners());
        factory.setMessageListeners(new MessageListeners());
        factory.setGlobalMessageConstructionInterceptors(new GlobalMessageConstructionInterceptors());
        factory.setEndpointFactory(new DefaultEndpointFactory());
        factory.setReferenceResolver(new SpringBeanReferenceResolver());
        factory.setNamespaceContextBuilder(new NamespaceContextBuilder());
        return factory;
    }

    public static TestContextFactory newInstance(ApplicationContext applicationContext) {
        TestContextFactory factory = new TestContextFactory();
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(FunctionRegistry.class))) {
            factory.setFunctionRegistry((FunctionRegistry)applicationContext.getBean(FunctionRegistry.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(ValidationMatcherRegistry.class))) {
            factory.setValidationMatcherRegistry((ValidationMatcherRegistry)applicationContext.getBean(ValidationMatcherRegistry.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(GlobalVariables.class))) {
            factory.setGlobalVariables((GlobalVariables)applicationContext.getBean(GlobalVariables.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(MessageValidatorRegistry.class))) {
            factory.setMessageValidatorRegistry((MessageValidatorRegistry)applicationContext.getBean(MessageValidatorRegistry.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(TestListeners.class))) {
            factory.setTestListeners((TestListeners)applicationContext.getBean(TestListeners.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(MessageListeners.class))) {
            factory.setMessageListeners((MessageListeners)applicationContext.getBean(MessageListeners.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(GlobalMessageConstructionInterceptors.class))) {
            factory.setGlobalMessageConstructionInterceptors((GlobalMessageConstructionInterceptors)applicationContext.getBean(GlobalMessageConstructionInterceptors.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(EndpointFactory.class))) {
            factory.setEndpointFactory((EndpointFactory)applicationContext.getBean(EndpointFactory.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(ReferenceResolver.class))) {
            factory.setReferenceResolver((ReferenceResolver)applicationContext.getBean(ReferenceResolver.class));
        }
        if (!CollectionUtils.isEmpty((Map)applicationContext.getBeansOfType(NamespaceContextBuilder.class))) {
            factory.setNamespaceContextBuilder((NamespaceContextBuilder)applicationContext.getBean(NamespaceContextBuilder.class));
        }
        factory.setApplicationContext(applicationContext);
        return factory;
    }

    public TestContext getObject() {
        TestContext context = new TestContext();
        context.setFunctionRegistry(this.functionRegistry);
        context.setValidationMatcherRegistry(this.validationMatcherRegistry);
        context.setGlobalVariables(this.globalVariables);
        context.setMessageValidatorRegistry(this.messageValidatorRegistry);
        context.setTestListeners(this.testListeners);
        context.setMessageListeners(this.messageListeners);
        context.setGlobalMessageConstructionInterceptors(this.globalMessageConstructionInterceptors);
        context.setEndpointFactory(this.endpointFactory);
        context.setReferenceResolver(this.referenceResolver);
        context.setApplicationContext(this.applicationContext);
        if (this.namespaceContextBuilder != null) {
            context.setNamespaceContextBuilder(this.namespaceContextBuilder);
        }
        if (log.isDebugEnabled()) {
            log.debug("Created new test context - using global variables: '" + context.getGlobalVariables() + "'");
        }
        return context;
    }

    public Class getObjectType() {
        return TestContext.class;
    }

    public boolean isSingleton() {
        return false;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setValidationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
        this.validationMatcherRegistry = validationMatcherRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
    }

    public GlobalVariables getGlobalVariables() {
        return this.globalVariables;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public void setTestListeners(TestListeners testListeners) {
        this.testListeners = testListeners;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public void setMessageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
        this.messageValidatorRegistry = messageValidatorRegistry;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public void setMessageListeners(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public void setGlobalMessageConstructionInterceptors(GlobalMessageConstructionInterceptors messageConstructionInterceptors) {
        this.globalMessageConstructionInterceptors = messageConstructionInterceptors;
    }

    public GlobalMessageConstructionInterceptors getGlobalMessageConstructionInterceptors() {
        return this.globalMessageConstructionInterceptors;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

