/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.TestCase;
import com.consol.citrus.container.StopTimer;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.endpoint.EndpointFactory;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.VariableNullValueException;
import com.consol.citrus.functions.FunctionRegistry;
import com.consol.citrus.functions.FunctionUtils;
import com.consol.citrus.message.DefaultMessageStore;
import com.consol.citrus.message.Message;
import com.consol.citrus.message.MessageStore;
import com.consol.citrus.report.MessageListeners;
import com.consol.citrus.report.TestListeners;
import com.consol.citrus.util.TypeConversionUtils;
import com.consol.citrus.validation.MessageValidatorRegistry;
import com.consol.citrus.validation.interceptor.GlobalMessageConstructionInterceptors;
import com.consol.citrus.validation.matcher.ValidationMatcherRegistry;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.VariableUtils;
import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TestContext {
    private static Logger log = LoggerFactory.getLogger(TestContext.class);
    protected Map<String, Object> variables;
    private GlobalVariables globalVariables;
    private MessageStore messageStore = new DefaultMessageStore();
    private FunctionRegistry functionRegistry = new FunctionRegistry();
    private EndpointFactory endpointFactory;
    private ReferenceResolver referenceResolver;
    private MessageValidatorRegistry messageValidatorRegistry = new MessageValidatorRegistry();
    private ValidationMatcherRegistry validationMatcherRegistry = new ValidationMatcherRegistry();
    private TestListeners testListeners = new TestListeners();
    private MessageListeners messageListeners = new MessageListeners();
    private GlobalMessageConstructionInterceptors globalMessageConstructionInterceptors = new GlobalMessageConstructionInterceptors();
    private NamespaceContextBuilder namespaceContextBuilder = new NamespaceContextBuilder();
    private ApplicationContext applicationContext;
    protected Map<String, StopTimer> timers = new ConcurrentHashMap<String, StopTimer>();
    private List<CitrusRuntimeException> exceptions = new ArrayList<CitrusRuntimeException>();

    public TestContext() {
        this.variables = new ConcurrentHashMap<String, Object>();
    }

    public String getVariable(String variableExpression) {
        return this.getVariable(variableExpression, String.class);
    }

    public <T> T getVariable(String variableExpression, Class<T> type) {
        return TypeConversionUtils.convertIfNecessary(this.getVariableObject(variableExpression), type);
    }

    public Object getVariableObject(String variableExpression) {
        String objectName;
        String variableName = VariableUtils.cutOffVariablesPrefix(variableExpression);
        if (variableName.startsWith("//") && variableName.endsWith("//")) {
            return "${" + VariableUtils.cutOffVariablesEscaping(variableName) + "}";
        }
        if (this.variables.containsKey(variableName)) {
            return this.variables.get(variableName);
        }
        if (variableName.contains(".") && this.variables.containsKey(objectName = variableName.substring(0, variableName.indexOf(".")))) {
            return this.getVariable(this.variables.get(objectName), variableName.substring(variableName.indexOf(".") + 1));
        }
        throw new CitrusRuntimeException("Unknown variable '" + variableName + "'");
    }

    private Object getVariable(Object instance, String pathExpression) {
        String fieldName;
        String leftOver = null;
        if (pathExpression.contains(".")) {
            fieldName = pathExpression.substring(0, pathExpression.indexOf("."));
            leftOver = pathExpression.substring(pathExpression.indexOf(".") + 1);
        } else {
            fieldName = pathExpression;
        }
        Field field = ReflectionUtils.findField(instance.getClass(), (String)fieldName);
        if (field == null) {
            throw new CitrusRuntimeException(String.format("Failed to get variable - unknown field '%s' on type %s", fieldName, instance.getClass().getName()));
        }
        ReflectionUtils.makeAccessible((Field)field);
        Object fieldValue = ReflectionUtils.getField((Field)field, (Object)instance);
        if (StringUtils.hasText((String)leftOver)) {
            return this.getVariable(fieldValue, leftOver);
        }
        return fieldValue;
    }

    public void setVariable(String variableName, Object value) {
        if (!StringUtils.hasText((String)variableName) || VariableUtils.cutOffVariablesPrefix(variableName).length() == 0) {
            throw new CitrusRuntimeException("Can not create variable '" + variableName + "', please define proper variable name");
        }
        if (value == null) {
            throw new VariableNullValueException("Trying to set variable: " + VariableUtils.cutOffVariablesPrefix(variableName) + ", but variable value is null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Setting variable: " + VariableUtils.cutOffVariablesPrefix(variableName) + " with value: '" + value + "'");
        }
        this.variables.put(VariableUtils.cutOffVariablesPrefix(variableName), value);
    }

    public void addVariables(String[] variableNames, Object[] variableValues) {
        if (variableNames.length != variableValues.length) {
            throw new CitrusRuntimeException(String.format("Invalid context variable usage - received '%s' variables with '%s' values", variableNames.length, variableValues.length));
        }
        for (int i = 0; i < variableNames.length; ++i) {
            if (variableValues[i] == null) continue;
            this.setVariable(variableNames[i], variableValues[i]);
        }
    }

    public void addVariables(Map<String, Object> variablesToSet) {
        for (Map.Entry<String, Object> entry : variablesToSet.entrySet()) {
            if (entry.getValue() != null) {
                this.setVariable(entry.getKey(), entry.getValue());
                continue;
            }
            this.setVariable(entry.getKey(), "");
        }
    }

    public <T> Map<String, T> resolveDynamicValuesInMap(Map<String, T> map) {
        LinkedHashMap<String, String> target = new LinkedHashMap<String, String>(map.size());
        for (Map.Entry<String, T> entry : map.entrySet()) {
            String key = this.replaceDynamicContentInString(entry.getKey());
            T value = entry.getValue();
            if (value instanceof String) {
                target.put(key, this.replaceDynamicContentInString((String)value));
                continue;
            }
            target.put(key, (String)value);
        }
        return target;
    }

    public <T> List<T> resolveDynamicValuesInList(List<T> list) {
        ArrayList<String> variableFreeList = new ArrayList<String>(list.size());
        for (T value : list) {
            if (!(value instanceof String)) continue;
            variableFreeList.add(this.replaceDynamicContentInString((String)value));
        }
        return variableFreeList;
    }

    public <T> T[] resolveDynamicValuesInArray(T[] array) {
        return this.resolveDynamicValuesInList(Arrays.asList(array)).toArray(Arrays.copyOf(array, array.length));
    }

    public void clear() {
        this.variables.clear();
        this.variables.putAll(this.globalVariables.getVariables());
    }

    public boolean hasVariables() {
        return !CollectionUtils.isEmpty(this.variables);
    }

    public String replaceDynamicContentInString(String str) {
        return this.replaceDynamicContentInString(str, false);
    }

    public String replaceDynamicContentInString(String str, boolean enableQuoting) {
        String result = null;
        if (str != null) {
            result = VariableUtils.replaceVariablesInString(str, this, enableQuoting);
            result = FunctionUtils.replaceFunctionsInString(result, this, enableQuoting);
        }
        return result;
    }

    public String resolveDynamicValue(String expression) {
        if (VariableUtils.isVariableName(expression)) {
            return this.getVariable(expression);
        }
        if (this.functionRegistry.isFunction(expression)) {
            return FunctionUtils.resolveFunction(expression, this);
        }
        return expression;
    }

    public CitrusRuntimeException handleError(String testName, String packageName, String message, Exception cause) {
        TestCase dummyTest = new TestCase();
        dummyTest.setName(testName);
        dummyTest.setPackageName(packageName);
        CitrusRuntimeException exception = new CitrusRuntimeException(message, cause);
        this.testListeners.onTestStart(dummyTest);
        this.testListeners.onTestFailure(dummyTest, exception);
        this.testListeners.onTestFinish(dummyTest);
        return exception;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public void setGlobalVariables(GlobalVariables globalVariables) {
        this.globalVariables = globalVariables;
        this.variables.putAll(globalVariables.getVariables());
    }

    public Map<String, Object> getGlobalVariables() {
        return this.globalVariables.getVariables();
    }

    public void setMessageStore(MessageStore messageStore) {
        this.messageStore = messageStore;
    }

    public MessageStore getMessageStore() {
        return this.messageStore;
    }

    public FunctionRegistry getFunctionRegistry() {
        return this.functionRegistry;
    }

    public void setFunctionRegistry(FunctionRegistry functionRegistry) {
        this.functionRegistry = functionRegistry;
    }

    public void setMessageValidatorRegistry(MessageValidatorRegistry messageValidatorRegistry) {
        this.messageValidatorRegistry = messageValidatorRegistry;
    }

    public MessageValidatorRegistry getMessageValidatorRegistry() {
        return this.messageValidatorRegistry;
    }

    public ValidationMatcherRegistry getValidationMatcherRegistry() {
        return this.validationMatcherRegistry;
    }

    public void setValidationMatcherRegistry(ValidationMatcherRegistry validationMatcherRegistry) {
        this.validationMatcherRegistry = validationMatcherRegistry;
    }

    public MessageListeners getMessageListeners() {
        return this.messageListeners;
    }

    public void setMessageListeners(MessageListeners messageListeners) {
        this.messageListeners = messageListeners;
    }

    public TestListeners getTestListeners() {
        return this.testListeners;
    }

    public void setTestListeners(TestListeners testListeners) {
        this.testListeners = testListeners;
    }

    public GlobalMessageConstructionInterceptors getGlobalMessageConstructionInterceptors() {
        return this.globalMessageConstructionInterceptors;
    }

    public void setGlobalMessageConstructionInterceptors(GlobalMessageConstructionInterceptors messageConstructionInterceptors) {
        this.globalMessageConstructionInterceptors = messageConstructionInterceptors;
    }

    public EndpointFactory getEndpointFactory() {
        return this.endpointFactory;
    }

    public void setEndpointFactory(EndpointFactory endpointFactory) {
        this.endpointFactory = endpointFactory;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.referenceResolver;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    public void setNamespaceContextBuilder(NamespaceContextBuilder namespaceContextBuilder) {
        this.namespaceContextBuilder = namespaceContextBuilder;
    }

    public NamespaceContextBuilder getNamespaceContextBuilder() {
        return this.namespaceContextBuilder;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void onInboundMessage(Message receivedMessage) {
        if (this.messageListeners != null && !this.messageListeners.isEmpty()) {
            this.messageListeners.onInboundMessage(receivedMessage, this);
        } else if (log.isDebugEnabled()) {
            log.debug("Received message:" + System.getProperty("line.separator") + (receivedMessage != null ? receivedMessage.toString() : ""));
        }
    }

    public void onOutboundMessage(Message message) {
        if (this.messageListeners != null && !this.messageListeners.isEmpty()) {
            this.messageListeners.onOutboundMessage(message, this);
        } else if (log.isDebugEnabled()) {
            log.debug("Sent message:" + System.getProperty("line.separator") + message.toString());
        }
    }

    public void registerTimer(String timerId, StopTimer timer) {
        if (this.timers.containsKey(timerId)) {
            throw new CitrusRuntimeException("Timer already registered with this id");
        }
        this.timers.put(timerId, timer);
    }

    public boolean stopTimer(String timerId) {
        StopTimer timer = this.timers.get(timerId);
        if (timer != null) {
            timer.stopTimer();
            return true;
        }
        return false;
    }

    public void stopTimers() {
        for (String timerId : this.timers.keySet()) {
            this.stopTimer(timerId);
        }
    }

    public void addException(CitrusRuntimeException exception) {
        this.exceptions.add(exception);
    }

    public List<CitrusRuntimeException> getExceptions() {
        return this.exceptions;
    }
}

