/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.context;

import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringBeanReferenceResolver
implements ReferenceResolver,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    @Override
    public <T> T resolve(Class<T> requiredType) {
        try {
            return (T)this.applicationContext.getBean(requiredType);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for type '%s'", requiredType), e);
        }
    }

    @Override
    public <T> T resolve(String name, Class<T> type) {
        try {
            return (T)this.applicationContext.getBean(name, type);
        }
        catch (NoSuchBeanDefinitionException e) {
            throw new CitrusRuntimeException(String.format("Unable to find bean reference for name '%s'", name), e);
        }
    }

    @Override
    public <T> List<T> resolve(String[] names, Class<T> type) {
        ArrayList<T> resolved = new ArrayList<T>();
        for (String name : names) {
            resolved.add(this.resolve(name, type));
        }
        return resolved;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}

