/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.condition.ActionCondition;
import com.consol.citrus.condition.Condition;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class Wait
extends AbstractActionContainer {
    private static final Logger log = LoggerFactory.getLogger(Wait.class);
    private TestAction action;
    private Condition condition;
    private String seconds;
    private String milliseconds = "5000";
    private String interval = "1000";

    public Wait() {
        this.setName("wait");
    }

    @Override
    public void doExecute(TestContext context) {
        Boolean conditionSatisfied = null;
        long timeLeft = this.getWaitTimeMs(context);
        long intervalMs = this.getIntervalMs(context);
        if (intervalMs > timeLeft) {
            intervalMs = timeLeft;
        }
        if (this.condition == null) {
            this.condition = new ActionCondition(Optional.ofNullable(this.action).orElseThrow(() -> new CitrusRuntimeException("Invalid wait condition -  null")));
        }
        Callable<Boolean> callable = () -> this.condition.isSatisfied(context);
        while (timeLeft > 0L) {
            timeLeft -= intervalMs;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Waiting for condition %s", this.condition.getName()));
            }
            ExecutorService executor = Executors.newSingleThreadExecutor();
            Future<Boolean> future = executor.submit(callable);
            long checkStartTime = System.currentTimeMillis();
            try {
                conditionSatisfied = future.get(intervalMs, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                log.warn(String.format("Condition check interrupted with '%s'", e.getClass().getSimpleName()));
            }
            executor.shutdown();
            if (Boolean.TRUE.equals(conditionSatisfied)) {
                log.info(this.condition.getSuccessMessage(context));
                return;
            }
            long sleepTime = intervalMs - (System.currentTimeMillis() - checkStartTime);
            if (sleepTime <= 0L) continue;
            try {
                Thread.sleep(sleepTime);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted during wait!", (Throwable)e);
            }
        }
        throw new CitrusRuntimeException(this.condition.getErrorMessage(context));
    }

    private long getWaitTimeMs(TestContext context) {
        if (StringUtils.hasText((String)this.seconds)) {
            return Long.valueOf(context.replaceDynamicContentInString(this.seconds)) * 1000L;
        }
        return Long.valueOf(context.replaceDynamicContentInString(this.milliseconds));
    }

    @Override
    public Wait addTestAction(TestAction action) {
        this.action = action;
        super.addTestAction(action);
        return this;
    }

    @Override
    public TestAction getTestAction(int index) {
        if (index == 0) {
            return this.action;
        }
        throw new IndexOutOfBoundsException("Illegal index in action list:" + index);
    }

    @Override
    public Wait setActions(List<TestAction> actions) {
        if (actions.size() > 1) {
            throw new CitrusRuntimeException("Invalid number of nested test actions - only one single nested action is allowed");
        }
        this.action = actions.get(0);
        super.setActions((List)actions);
        return this;
    }

    private long getIntervalMs(TestContext context) {
        return Long.valueOf(context.replaceDynamicContentInString(this.interval));
    }

    public String getSeconds() {
        return this.seconds;
    }

    public void setSeconds(String seconds) {
        this.seconds = seconds;
    }

    public String getMilliseconds() {
        return this.milliseconds;
    }

    public void setMilliseconds(String milliseconds) {
        this.milliseconds = milliseconds;
    }

    public Condition getCondition() {
        return this.condition;
    }

    public void setCondition(Condition condition) {
        this.condition = condition;
    }

    public String getInterval() {
        return this.interval;
    }

    public void setInterval(String interval) {
        this.interval = interval;
    }

    public void setAction(TestAction action) {
        this.addTestAction(action);
    }

    public TestAction getAction() {
        return this.action;
    }
}

