/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.StopTimer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.util.StringUtils;

public class Timer
extends AbstractActionContainer
implements StopTimer {
    private static Logger log = LoggerFactory.getLogger(Timer.class);
    private static final AtomicInteger nextSerialNumber = new AtomicInteger(0);
    protected static final String INDEX_SUFFIX = "-index";
    private long interval = 1000L;
    private long delay = 0L;
    private int repeatCount = Integer.MAX_VALUE;
    private boolean fork = false;
    private String timerId;
    protected boolean timerComplete = false;
    protected CitrusRuntimeException timerException = null;
    private java.util.Timer timer;

    public Timer() {
        this.setName("timer");
    }

    @Override
    public void doExecute(final TestContext context) {
        if (this.fork) {
            SimpleAsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor();
            taskExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    Timer.this.configureAndRunTimer(context);
                }
            });
        } else {
            this.configureAndRunTimer(context);
        }
    }

    private void configureAndRunTimer(final TestContext context) {
        this.timer = new java.util.Timer(this.getTimerId(), false);
        context.registerTimer(this.getTimerId(), this);
        TimerTask timerTask = new TimerTask(){
            int indexCount = 0;

            @Override
            public void run() {
                try {
                    ++this.indexCount;
                    this.updateIndexCountInTestContext(context);
                    log.debug(String.format("Timer event fired #%s - executing nested actions", this.indexCount));
                    for (TestAction action : Timer.this.actions) {
                        Timer.this.setActiveAction(action);
                        action.execute(context);
                    }
                    if (this.indexCount >= Timer.this.repeatCount) {
                        log.debug(String.format("Timer complete: %s iterations reached", Timer.this.repeatCount));
                        Timer.this.stopTimer();
                    }
                }
                catch (Exception e) {
                    this.handleException(e);
                }
            }

            private void updateIndexCountInTestContext(TestContext context2) {
                context2.setVariable(Timer.this.getTimerId() + Timer.INDEX_SUFFIX, String.valueOf(this.indexCount));
            }

            private void handleException(Exception e) {
                Timer.this.timerException = e instanceof CitrusRuntimeException ? (CitrusRuntimeException)e : new CitrusRuntimeException(e);
                log.error(String.format("Timer stopped as a result of nested action error (%s)", e.getMessage()));
                Timer.this.stopTimer();
                if (Timer.this.fork) {
                    context.addException(Timer.this.timerException);
                }
            }
        };
        this.timer.scheduleAtFixedRate(timerTask, this.delay, this.interval);
        while (!this.timerComplete) {
            try {
                Thread.sleep(this.interval);
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for timer to complete", (Throwable)e);
            }
        }
        if (this.timerException != null) {
            throw this.timerException;
        }
    }

    public String getTimerId() {
        if (StringUtils.isEmpty((Object)this.timerId)) {
            this.timerId = "citrus-timer-" + Timer.serialNumber();
        }
        return this.timerId;
    }

    @Override
    public void stopTimer() {
        this.timer.cancel();
        this.timerComplete = true;
    }

    private static int serialNumber() {
        return nextSerialNumber.getAndIncrement();
    }

    public long getInterval() {
        return this.interval;
    }

    public void setInterval(long interval) {
        this.interval = interval;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public int getRepeatCount() {
        return this.repeatCount;
    }

    public void setRepeatCount(int repeatCount) {
        this.repeatCount = repeatCount;
    }

    public void setTimerId(String timerId) {
        this.timerId = timerId;
    }

    public boolean isFork() {
        return this.fork;
    }

    public void setFork(boolean fork) {
        this.fork = fork;
    }
}

