/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.functions.FunctionUtils;
import com.consol.citrus.variable.GlobalVariables;
import com.consol.citrus.variable.VariableUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template
extends AbstractTestAction {
    private List<TestAction> actions = new ArrayList<TestAction>();
    private Map<String, String> parameter = new LinkedHashMap<String, String>();
    private boolean globalContext = true;
    private static Logger log = LoggerFactory.getLogger(Template.class);

    @Override
    public void doExecute(TestContext context) {
        TestContext innerContext;
        if (log.isDebugEnabled()) {
            log.debug("Executing template '" + this.getName() + "' with " + this.actions.size() + " embedded actions");
        }
        if (this.globalContext) {
            innerContext = context;
        } else {
            innerContext = new TestContext();
            innerContext.setFunctionRegistry(context.getFunctionRegistry());
            GlobalVariables globalVariables = new GlobalVariables();
            globalVariables.getVariables().putAll(context.getGlobalVariables());
            innerContext.setGlobalVariables(globalVariables);
            innerContext.getVariables().putAll(context.getVariables());
            innerContext.setMessageStore(context.getMessageStore());
            innerContext.setMessageValidatorRegistry(context.getMessageValidatorRegistry());
            innerContext.setValidationMatcherRegistry(context.getValidationMatcherRegistry());
            innerContext.setTestListeners(context.getTestListeners());
            innerContext.setMessageListeners(context.getMessageListeners());
            innerContext.setGlobalMessageConstructionInterceptors(context.getGlobalMessageConstructionInterceptors());
            innerContext.setEndpointFactory(context.getEndpointFactory());
            innerContext.setNamespaceContextBuilder(context.getNamespaceContextBuilder());
            innerContext.setApplicationContext(context.getApplicationContext());
        }
        for (Map.Entry<String, String> entry : this.parameter.entrySet()) {
            String param = entry.getKey();
            String paramValue = entry.getValue();
            paramValue = VariableUtils.replaceVariablesInString(paramValue, innerContext, false);
            if (context.getFunctionRegistry().isFunction(paramValue)) {
                paramValue = FunctionUtils.resolveFunction(paramValue, context);
            }
            if (log.isDebugEnabled()) {
                log.debug("Setting parameter for template " + param + "=" + paramValue);
            }
            innerContext.setVariable(param, paramValue);
        }
        for (TestAction action : this.actions) {
            action.execute(innerContext);
        }
        log.info("Template was executed successfully");
    }

    public void setActions(List<TestAction> actions) {
        this.actions = actions;
    }

    public void setParameter(Map<String, String> parameter) {
        this.parameter = parameter;
    }

    public void setGlobalContext(boolean globalContext) {
        this.globalContext = globalContext;
    }

    public Map<String, String> getParameter() {
        return this.parameter;
    }

    public boolean isGlobalContext() {
        return this.globalContext;
    }

    public List<TestAction> getActions() {
        return this.actions;
    }
}

