/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.container.AbstractIteratingActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepeatOnErrorUntilTrue
extends AbstractIteratingActionContainer {
    private Long autoSleep = 1000L;
    private static Logger log = LoggerFactory.getLogger(RepeatOnErrorUntilTrue.class);

    public RepeatOnErrorUntilTrue() {
        this.setName("repeat-on-error");
    }

    @Override
    public void executeIteration(TestContext context) {
        CitrusRuntimeException exception = null;
        while (!this.checkCondition(context)) {
            try {
                exception = null;
                this.executeActions(context);
                break;
            }
            catch (CitrusRuntimeException e) {
                exception = e;
                log.info("Caught exception of type " + e.getClass().getName() + " '" + e.getMessage() + "' - performing retry #" + this.index);
                this.doAutoSleep();
                ++this.index;
            }
        }
        if (exception != null) {
            log.info("All retries failed - raising exception " + exception.getClass().getName());
            throw exception;
        }
    }

    private void doAutoSleep() {
        if (this.autoSleep > 0L) {
            log.info("Sleeping " + this.autoSleep + " milliseconds");
            try {
                Thread.sleep(this.autoSleep);
            }
            catch (InterruptedException e) {
                log.error("Error during doc generation", (Throwable)e);
            }
            log.info("Returning after " + this.autoSleep + " milliseconds");
        }
    }

    public void setAutoSleep(Long autoSleep) {
        this.autoSleep = autoSleep;
    }

    public Long getAutoSleep() {
        return this.autoSleep;
    }
}

