/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ParallelContainerException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parallel
extends AbstractActionContainer {
    private Stack<Thread> threads = new Stack();
    private List<CitrusRuntimeException> exceptions = new ArrayList<CitrusRuntimeException>();
    private static Logger log = LoggerFactory.getLogger(Parallel.class);

    public Parallel() {
        this.setName("parallel");
    }

    @Override
    public void doExecute(TestContext context) {
        for (final TestAction action : this.actions) {
            Thread t = new Thread(new ActionRunner(action, context){

                @Override
                public void exceptionCallback(CitrusRuntimeException e) {
                    if (Parallel.this.exceptions.isEmpty()) {
                        Parallel.this.setActiveAction(action);
                    }
                    Parallel.this.exceptions.add(e);
                }
            });
            this.threads.push(t);
            t.start();
        }
        while (!this.threads.isEmpty()) {
            try {
                this.threads.pop().join();
            }
            catch (InterruptedException e) {
                log.error("Unable to join thread", (Throwable)e);
            }
        }
        if (!this.exceptions.isEmpty()) {
            if (this.exceptions.size() == 1) {
                throw this.exceptions.get(0);
            }
            throw new ParallelContainerException(this.exceptions);
        }
    }

    private static abstract class ActionRunner
    implements Runnable {
        private TestAction action;
        private TestContext context;

        public ActionRunner(TestAction action, TestContext context) {
            this.action = action;
            this.context = context;
        }

        @Override
        public void run() {
            try {
                this.action.execute(this.context);
            }
            catch (CitrusRuntimeException e) {
                log.error("Parallel test action raised error", (Throwable)e);
                this.exceptionCallback(e);
            }
            catch (RuntimeException e) {
                log.error("Parallel test action raised error", (Throwable)e);
                this.exceptionCallback(new CitrusRuntimeException(e));
            }
            catch (Exception e) {
                log.error("Parallel test action raised error", (Throwable)e);
                this.exceptionCallback(new CitrusRuntimeException(e));
            }
            catch (AssertionError e) {
                log.error("Parallel test action raised error", (Throwable)((Object)e));
                this.exceptionCallback(new CitrusRuntimeException((Throwable)((Object)e)));
            }
        }

        public abstract void exceptionCallback(CitrusRuntimeException var1);
    }
}

