/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.ConditionExpression;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.BooleanExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Conditional
extends AbstractActionContainer {
    private static Logger log = LoggerFactory.getLogger(Conditional.class);
    protected String condition;
    private ConditionExpression conditionExpression;

    public Conditional() {
        this.setName("conditional");
    }

    @Override
    public void doExecute(TestContext context) {
        if (this.checkCondition(context)) {
            log.debug("Condition [ {} ] evaluates to true, executing nested actions", (Object)this.condition);
            for (TestAction action : this.actions) {
                this.setActiveAction(action);
                action.execute(context);
            }
        } else {
            log.debug("Condition [ {} ] evaluates to false, not executing nested actions", (Object)this.condition);
        }
    }

    private boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(context);
        }
        String conditionString = context.replaceDynamicContentInString(this.condition);
        if (ValidationMatcherUtils.isValidationMatcherExpression(conditionString)) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher("iteratingCondition", "", conditionString, context);
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setConditionExpression(ConditionExpression conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public ConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }
}

