/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Catch
extends AbstractActionContainer {
    private String exception = CitrusRuntimeException.class.getName();
    private static Logger log = LoggerFactory.getLogger(Catch.class);

    public Catch() {
        this.setName("catch");
    }

    @Override
    public void doExecute(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Catch container catching exceptions of type " + this.exception);
        }
        for (TestAction action : this.actions) {
            try {
                this.setActiveAction(action);
                action.execute(context);
            }
            catch (Exception e) {
                if (this.exception != null && this.exception.equals(e.getClass().getName())) {
                    log.info("Caught exception " + e.getClass() + ": " + e.getLocalizedMessage());
                    continue;
                }
                throw new CitrusRuntimeException(e);
            }
        }
    }

    public void setException(String exception) {
        this.exception = exception;
    }

    public String getException() {
        return this.exception;
    }
}

