/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.actions.AbstractAsyncTestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Async
extends AbstractActionContainer {
    private static Logger log = LoggerFactory.getLogger(Async.class);
    private List<TestAction> errorActions = new ArrayList<TestAction>();
    private List<TestAction> successActions = new ArrayList<TestAction>();

    public Async() {
        this.setName("async");
    }

    @Override
    public void doExecute(TestContext context) {
        log.debug("Async container forking action execution ...");
        AbstractAsyncTestAction asyncTestAction = new AbstractAsyncTestAction(){

            @Override
            public void doExecuteAsync(TestContext context) {
                for (TestAction action : Async.this.actions) {
                    Async.this.setActiveAction(action);
                    action.execute(context);
                }
            }

            @Override
            public void onError(TestContext context, Throwable error) {
                log.info("Apply error actions after async container ...");
                for (TestAction action : Async.this.errorActions) {
                    action.execute(context);
                }
            }

            @Override
            public void onSuccess(TestContext context) {
                log.info("Apply success actions after async container ...");
                for (TestAction action : Async.this.successActions) {
                    action.execute(context);
                }
            }
        };
        this.setActiveAction(asyncTestAction);
        asyncTestAction.execute(context);
    }

    public Async addErrorAction(TestAction action) {
        this.errorActions.add(action);
        return this;
    }

    public Async addSuccessAction(TestAction action) {
        this.successActions.add(action);
        return this;
    }

    public Async addErrorActions(TestAction ... actions) {
        this.errorActions.addAll(Arrays.asList(actions));
        return this;
    }

    public Async addSuccessActions(TestAction ... actions) {
        this.successActions.addAll(Arrays.asList(actions));
        return this;
    }

    public void setSuccessActions(List<TestAction> successActions) {
        this.successActions = successActions;
    }

    public List<TestAction> getSuccessActions() {
        return this.successActions;
    }

    public void setErrorActions(List<TestAction> errorActions) {
        this.errorActions = errorActions;
    }

    public List<TestAction> getErrorActions() {
        return this.errorActions;
    }
}

