/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.exceptions.CitrusRuntimeException;
import com.consol.citrus.exceptions.ValidationException;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Assert
extends AbstractActionContainer {
    private TestAction action;
    private Class<? extends Throwable> exception = CitrusRuntimeException.class;
    private String message = null;
    private static Logger log = LoggerFactory.getLogger(Assert.class);

    public Assert() {
        this.setName("assert");
    }

    @Override
    public void doExecute(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug("Assert container asserting exceptions of type " + this.exception);
        }
        try {
            this.setActiveAction(this.action);
            this.action.execute(context);
        }
        catch (Exception e) {
            log.debug("Validating caught exception ...");
            if (!this.exception.isAssignableFrom(e.getClass())) {
                throw new ValidationException("Validation failed for asserted exception type - expected: '" + this.exception + "' but was: '" + e.getClass().getName() + "'", e);
            }
            if (this.message != null) {
                if (ValidationMatcherUtils.isValidationMatcherExpression(this.message)) {
                    ValidationMatcherUtils.resolveValidationMatcher("message", e.getLocalizedMessage(), this.message, context);
                } else if (!context.replaceDynamicContentInString(this.message).equals(e.getLocalizedMessage())) {
                    throw new ValidationException("Validation failed for asserted exception message - expected: '" + this.message + "' but was: '" + e.getLocalizedMessage() + "'", e);
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Asserted exception is as expected: " + e.getClass() + ": " + e.getLocalizedMessage());
            }
            log.info("Assert exception validation successful: All values OK");
            return;
        }
        throw new ValidationException("Missing asserted exception '" + this.exception + "'");
    }

    public void setAction(TestAction action) {
        this.addTestAction(action);
    }

    public TestAction getAction() {
        return this.action;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public Class<? extends Throwable> getException() {
        return this.exception;
    }

    public void setException(Class<? extends Throwable> exception) {
        this.exception = exception;
    }

    @Override
    public Assert addTestAction(TestAction action) {
        this.action = action;
        super.addTestAction(action);
        return this;
    }

    @Override
    public TestAction getTestAction(int index) {
        if (index == 0) {
            return this.action;
        }
        throw new IndexOutOfBoundsException("Illegal index in action list:" + index);
    }

    @Override
    public Assert setActions(List<TestAction> actions) {
        if (actions.size() > 1) {
            throw new CitrusRuntimeException("Invalid number of nested test actions - only one single nested action is allowed");
        }
        this.action = actions.get(0);
        super.setActions((List)actions);
        return this;
    }
}

