/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.TestAction;
import com.consol.citrus.container.AbstractActionContainer;
import com.consol.citrus.container.IteratingConditionExpression;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.BooleanExpressionParser;
import com.consol.citrus.validation.matcher.ValidationMatcherUtils;
import java.util.Properties;
import org.springframework.util.PropertyPlaceholderHelper;

public abstract class AbstractIteratingActionContainer
extends AbstractActionContainer {
    protected String condition;
    protected IteratingConditionExpression conditionExpression;
    protected String indexName = "i";
    protected int index;
    protected int start = 1;

    @Override
    public final void doExecute(TestContext context) {
        this.index = this.start;
        this.executeIteration(context);
    }

    protected abstract void executeIteration(TestContext var1);

    protected void executeActions(TestContext context) {
        context.setVariable(this.indexName, String.valueOf(this.index));
        for (TestAction action : this.actions) {
            this.setActiveAction(action);
            action.execute(context);
        }
    }

    protected boolean checkCondition(TestContext context) {
        if (this.conditionExpression != null) {
            return this.conditionExpression.evaluate(this.index, context);
        }
        String conditionString = this.condition;
        if (conditionString.indexOf("${" + this.indexName + "}") != -1) {
            Properties props = new Properties();
            props.put(this.indexName, String.valueOf(this.index));
            conditionString = new PropertyPlaceholderHelper("${", "}").replacePlaceholders(conditionString, props);
        }
        if (ValidationMatcherUtils.isValidationMatcherExpression(conditionString = context.replaceDynamicContentInString(conditionString))) {
            try {
                ValidationMatcherUtils.resolveValidationMatcher("iteratingCondition", String.valueOf(this.index), conditionString, context);
                return true;
            }
            catch (AssertionError e) {
                return false;
            }
        }
        if (conditionString.indexOf(this.indexName) != -1) {
            conditionString = conditionString.replaceAll(this.indexName, String.valueOf(this.index));
        }
        return BooleanExpressionParser.evaluate(conditionString);
    }

    @Override
    public boolean isDone(TestContext context) {
        return super.isDone(context) || !this.checkCondition(context);
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public void setConditionExpression(IteratingConditionExpression conditionExpression) {
        this.conditionExpression = conditionExpression;
    }

    public void setIndexName(String indexName) {
        this.indexName = indexName;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public String getCondition() {
        return this.condition;
    }

    public IteratingConditionExpression getConditionExpression() {
        return this.conditionExpression;
    }

    public String getIndexName() {
        return this.indexName;
    }

    public int getIndex() {
        return this.index;
    }

    public int getStart() {
        return this.start;
    }
}

