/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.container;

import com.consol.citrus.Completable;
import com.consol.citrus.TestAction;
import com.consol.citrus.actions.AbstractTestAction;
import com.consol.citrus.container.TestActionContainer;
import com.consol.citrus.context.TestContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public abstract class AbstractActionContainer
extends AbstractTestAction
implements TestActionContainer,
Completable {
    protected List<TestAction> actions = new ArrayList<TestAction>();
    private List<TestAction> executedActions = new ArrayList<TestAction>();
    private TestAction activeAction;

    @Override
    public AbstractActionContainer setActions(List<TestAction> actions) {
        this.actions = actions;
        return this;
    }

    @Override
    public AbstractActionContainer addTestActions(TestAction ... toAdd) {
        this.actions.addAll(Arrays.asList(toAdd));
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isDone(TestContext context) {
        if (this.isDisabled(context)) return true;
        if (!this.executedActions.stream().filter(action -> action instanceof Completable).map(Completable.class::cast).allMatch(action -> action.isDone(context))) return false;
        return true;
    }

    @Override
    public List<TestAction> getActions() {
        return this.actions;
    }

    @Override
    public long getActionCount() {
        return this.actions.size();
    }

    @Override
    public AbstractActionContainer addTestAction(TestAction action) {
        this.actions.add(action);
        return this;
    }

    @Override
    public int getActionIndex(TestAction action) {
        return this.actions.indexOf(action);
    }

    @Override
    public TestAction getActiveAction() {
        return this.activeAction;
    }

    @Override
    public void setActiveAction(TestAction action) {
        this.activeAction = action;
        this.executedActions.add(action);
    }

    @Override
    public List<TestAction> getExecutedActions() {
        return this.executedActions;
    }

    @Override
    public TestAction getTestAction(int index) {
        return this.actions.get(index);
    }
}

