/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.endpoint.adapter.StaticResponseEndpointAdapter;
import com.consol.citrus.message.MessageHeaderType;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.AbstractBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class StaticResponseEndpointAdapterParser
extends AbstractBeanDefinitionParser {
    protected AbstractBeanDefinition parseInternal(Element element, ParserContext parserContext) {
        Element headerElement;
        Element payloadResource;
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(StaticResponseEndpointAdapter.class);
        Element payloadData = DomUtils.getChildElementByTagName((Element)element, (String)"payload");
        if (payloadData != null) {
            builder.addPropertyValue("messagePayload", (Object)DomUtils.getTextValue((Element)payloadData));
        }
        if ((payloadResource = DomUtils.getChildElementByTagName((Element)element, (String)"resource")) != null) {
            builder.addPropertyValue("messagePayloadResource", (Object)payloadResource.getAttribute("file"));
            if (payloadResource.hasAttribute("charset")) {
                builder.addPropertyValue("messagePayloadResourceCharset", (Object)payloadResource.getAttribute("charset"));
            }
        }
        if ((headerElement = DomUtils.getChildElementByTagName((Element)element, (String)"header")) != null) {
            LinkedHashMap<String, String> messageHeaders = new LinkedHashMap<String, String>();
            List elements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"element");
            for (Element headerValue : elements) {
                String name = headerValue.getAttribute("name");
                String value = headerValue.getAttribute("value");
                String type = headerValue.getAttribute("type");
                if (StringUtils.hasText((String)type)) {
                    value = MessageHeaderType.createTypedValue(type, value);
                }
                messageHeaders.put(name, value);
            }
            builder.addPropertyValue("messageHeader", messageHeaders);
        }
        return builder.getBeanDefinition();
    }
}

