/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.SchemaParser;
import com.consol.citrus.json.JsonSchemaRepository;
import com.consol.citrus.xml.XsdSchemaRepository;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SchemaRepositoryParser
implements BeanDefinitionParser {
    private static final String LOCATION = "location";
    private static final String LOCATIONS = "locations";
    private static final String SCHEMA = "schema";
    private static final String SCHEMAS = "schemas";
    private static final String ID = "id";
    private final SchemaParser schemaParser = new SchemaParser();

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        if (this.isXmlSchemaRepository(element)) {
            this.registerXmlSchemaRepository(element, parserContext);
        } else if (this.isJsonSchemaRepository(element)) {
            this.registerJsonSchemaRepository(element, parserContext);
        }
        return null;
    }

    private void registerJsonSchemaRepository(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(JsonSchemaRepository.class);
        this.addLocationsToBuilder(element, builder);
        this.parseSchemasElement(element, builder, parserContext);
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute(ID), (BeanDefinition)builder.getBeanDefinition());
    }

    private void registerXmlSchemaRepository(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(XsdSchemaRepository.class);
        BeanDefinitionParserUtils.setPropertyReference(builder, element.getAttribute("schema-mapping-strategy"), "schemaMappingStrategy");
        this.addLocationsToBuilder(element, builder);
        this.parseSchemasElement(element, builder, parserContext);
        parserContext.getRegistry().registerBeanDefinition(element.getAttribute(ID), (BeanDefinition)builder.getBeanDefinition());
    }

    private boolean isXmlSchemaRepository(Element element) {
        String schemaRepositoryType = element.getAttribute("type");
        return StringUtils.isEmpty((Object)schemaRepositoryType) || "xml".equals(schemaRepositoryType);
    }

    private boolean isJsonSchemaRepository(Element element) {
        return Objects.equals(element.getAttribute("type"), "json");
    }

    private void addLocationsToBuilder(Element element, BeanDefinitionBuilder builder) {
        List locationElements;
        List locations;
        Element locationsElement = DomUtils.getChildElementByTagName((Element)element, (String)LOCATIONS);
        if (locationsElement != null && !(locations = (locationElements = DomUtils.getChildElementsByTagName((Element)locationsElement, (String)LOCATION)).stream().map(locationElement -> locationElement.getAttribute("path")).collect(Collectors.toList())).isEmpty()) {
            builder.addPropertyValue(LOCATIONS, locations);
        }
    }

    private void parseSchemasElement(Element element, BeanDefinitionBuilder builder, ParserContext parserContext) {
        List schemaElements;
        ManagedList<RuntimeBeanReference> beanReferences;
        Element schemasElement = DomUtils.getChildElementByTagName((Element)element, (String)SCHEMAS);
        if (schemasElement != null && !(beanReferences = this.constructRuntimeBeanReferences(parserContext, schemaElements = DomUtils.getChildElements((Element)schemasElement))).isEmpty()) {
            builder.addPropertyValue(SCHEMAS, beanReferences);
        }
    }

    private ManagedList<RuntimeBeanReference> constructRuntimeBeanReferences(ParserContext parserContext, List<Element> schemaElements) {
        ManagedList runtimeBeanReferences = new ManagedList();
        for (Element schemaElement : schemaElements) {
            if (schemaElement.hasAttribute(SCHEMA)) {
                runtimeBeanReferences.add((Object)new RuntimeBeanReference(schemaElement.getAttribute(SCHEMA)));
                continue;
            }
            this.schemaParser.parse(schemaElement, parserContext);
            runtimeBeanReferences.add((Object)new RuntimeBeanReference(schemaElement.getAttribute(ID)));
        }
        return runtimeBeanReferences;
    }
}

