/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.json.schema.SimpleJsonSchema;
import com.consol.citrus.xml.schema.WsdlXsdSchema;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.xml.xsd.SimpleXsdSchema;
import org.w3c.dom.Element;

public class SchemaParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String location = element.getAttribute("location");
        BeanDefinitionBuilder builder = null;
        if (location.endsWith(".wsdl")) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(WsdlXsdSchema.class);
            BeanDefinitionParserUtils.setPropertyValue(builder, location, "wsdl");
        } else if (location.endsWith(".xsd")) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(SimpleXsdSchema.class);
            BeanDefinitionParserUtils.setPropertyValue(builder, location, "xsd");
        } else if (location.endsWith(".json")) {
            builder = BeanDefinitionBuilder.genericBeanDefinition(SimpleJsonSchema.class);
            BeanDefinitionParserUtils.setPropertyValue(builder, location, "json");
        }
        if (builder != null) {
            parserContext.getRegistry().registerBeanDefinition(element.getAttribute("id"), (BeanDefinition)builder.getBeanDefinition());
        }
        return null;
    }
}

