/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.ExecuteSQLAction;
import com.consol.citrus.actions.ExecuteSQLQueryAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.validation.script.ScriptValidationContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class SQLActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition;
        String dataSource = element.getAttribute("datasource");
        if (!StringUtils.hasText((String)dataSource)) {
            throw new BeanCreationException("Missing proper data source reference");
        }
        List validateElements = DomUtils.getChildElementsByTagName((Element)element, (String)"validate");
        List extractElements = DomUtils.getChildElementsByTagName((Element)element, (String)"extract");
        Element scriptValidationElement = DomUtils.getChildElementByTagName((Element)element, (String)"validate-script");
        if (CollectionUtils.isEmpty((Collection)validateElements) && CollectionUtils.isEmpty((Collection)extractElements) && scriptValidationElement == null) {
            beanDefinition = this.parseSqlAction(element);
            beanDefinition.addPropertyValue("name", (Object)("sqlUpdate:" + dataSource));
        } else {
            beanDefinition = this.parseSqlQueryAction(element, scriptValidationElement, validateElements, extractElements);
            beanDefinition.addPropertyValue("name", (Object)("sqlQuery:" + dataSource));
        }
        beanDefinition.addPropertyReference("dataSource", dataSource);
        BeanDefinitionParserUtils.setPropertyReference(beanDefinition, element.getAttribute("transaction-manager"), "transactionManager");
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("transaction-timeout"), "transactionTimeout");
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("transaction-isolation-level"), "transactionIsolationLevel");
        DescriptionElementParser.doParse(element, beanDefinition);
        ArrayList<String> statements = new ArrayList<String>();
        List stmtElements = DomUtils.getChildElementsByTagName((Element)element, (String)"statement");
        for (Element stmt : stmtElements) {
            statements.add(DomUtils.getTextValue((Element)stmt));
        }
        beanDefinition.addPropertyValue("statements", statements);
        Element sqlResourceElement = DomUtils.getChildElementByTagName((Element)element, (String)"resource");
        if (sqlResourceElement != null) {
            beanDefinition.addPropertyValue("sqlResourcePath", (Object)sqlResourceElement.getAttribute("file"));
        }
        return beanDefinition.getBeanDefinition();
    }

    private BeanDefinitionBuilder parseSqlAction(Element element) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ExecuteSQLAction.class);
        String ignoreErrors = element.getAttribute("ignore-errors");
        if (ignoreErrors != null && ignoreErrors.equals("true")) {
            beanDefinition.addPropertyValue("ignoreErrors", (Object)true);
        }
        return beanDefinition;
    }

    private BeanDefinitionBuilder parseSqlQueryAction(Element element, Element scriptValidationElement, List<Element> validateElements, List<Element> extractElements) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ExecuteSQLQueryAction.class);
        if (scriptValidationElement != null) {
            beanDefinition.addPropertyValue("scriptValidationContext", (Object)this.getScriptValidationContext(scriptValidationElement));
        }
        HashMap<String, List<Object>> controlResultSet = new HashMap<String, List<Object>>();
        for (Element validateElement : validateElements) {
            Element valueListElement = DomUtils.getChildElementByTagName((Element)validateElement, (String)"values");
            if (valueListElement != null) {
                ArrayList<String> valueList = new ArrayList<String>();
                List valueElements = DomUtils.getChildElementsByTagName((Element)valueListElement, (String)"value");
                for (Element valueElement : valueElements) {
                    valueList.add(DomUtils.getTextValue((Element)valueElement));
                }
                controlResultSet.put(validateElement.getAttribute("column"), valueList);
                continue;
            }
            if (validateElement.hasAttribute("value")) {
                controlResultSet.put(validateElement.getAttribute("column"), Collections.singletonList(validateElement.getAttribute("value")));
                continue;
            }
            throw new BeanCreationException(element.getLocalName(), "Neither value attribute nor value list is set for column validation: " + validateElement.getAttribute("column"));
        }
        beanDefinition.addPropertyValue("controlResultSet", controlResultSet);
        HashMap<String, String> extractVariables = new HashMap<String, String>();
        for (Element validate : extractElements) {
            extractVariables.put(validate.getAttribute("column"), validate.getAttribute("variable"));
        }
        beanDefinition.addPropertyValue("extractVariables", extractVariables);
        return beanDefinition;
    }

    private ScriptValidationContext getScriptValidationContext(Element scriptElement) {
        String type = scriptElement.getAttribute("type");
        ScriptValidationContext validationContext = new ScriptValidationContext(type);
        String filePath = scriptElement.getAttribute("file");
        if (StringUtils.hasText((String)filePath)) {
            validationContext.setValidationScriptResourcePath(filePath);
        } else {
            validationContext.setValidationScript(DomUtils.getTextValue((Element)scriptElement));
        }
        return validationContext;
    }
}

