/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.ReceiveTimeoutAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.MessageSelectorParser;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReceiveTimeoutActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(ReceiveTimeoutAction.class);
        String endpointUri = element.getAttribute("endpoint");
        if (!StringUtils.hasText((String)endpointUri)) {
            throw new BeanCreationException("Missing proper message endpoint reference for expect timeout action - 'endpoint' attribute is required and should not be empty");
        }
        if (endpointUri.contains(":")) {
            beanDefinition.addPropertyValue("endpointUri", (Object)endpointUri);
        } else {
            beanDefinition.addPropertyReference("endpoint", endpointUri);
        }
        beanDefinition.addPropertyValue("name", (Object)(element.getLocalName() + ":" + endpointUri));
        DescriptionElementParser.doParse(element, beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("wait"), "timeout");
        Element messageSelectorElement = DomUtils.getChildElementByTagName((Element)element, (String)"select");
        if (messageSelectorElement != null) {
            beanDefinition.addPropertyValue("messageSelector", (Object)DomUtils.getTextValue((Element)messageSelectorElement));
        }
        MessageSelectorParser.doParse(element, beanDefinition);
        return beanDefinition.getBeanDefinition();
    }
}

