/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.Citrus;
import com.consol.citrus.actions.ReceiveMessageAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.util.ValidateMessageParserUtil;
import com.consol.citrus.config.util.VariableExtractorParserUtil;
import com.consol.citrus.config.xml.AbstractMessageActionParser;
import com.consol.citrus.config.xml.DescriptionElementParser;
import com.consol.citrus.config.xml.MessageSelectorParser;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.context.SchemaValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.json.JsonMessageValidationContext;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.script.ScriptValidationContext;
import com.consol.citrus.validation.xml.XmlMessageValidationContext;
import com.consol.citrus.validation.xml.XpathMessageValidationContext;
import com.consol.citrus.variable.VariableExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class ReceiveMessageActionParser
extends AbstractMessageActionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        String endpointUri = element.getAttribute("endpoint");
        if (!StringUtils.hasText((String)endpointUri)) {
            throw new BeanCreationException("Endpoint reference must not be empty");
        }
        BeanDefinitionBuilder builder = this.parseComponent(element, parserContext);
        builder.addPropertyValue("name", (Object)element.getLocalName());
        if (endpointUri.contains(":") || endpointUri.contains("${") && endpointUri.contains("}")) {
            builder.addPropertyValue("endpointUri", (Object)endpointUri);
        } else {
            builder.addPropertyReference("endpoint", endpointUri);
        }
        DescriptionElementParser.doParse(element, builder);
        BeanDefinitionParserUtils.setPropertyReference(builder, element.getAttribute("actor"), "actor");
        String receiveTimeout = element.getAttribute("timeout");
        if (StringUtils.hasText((String)receiveTimeout)) {
            builder.addPropertyValue("receiveTimeout", (Object)Long.valueOf(receiveTimeout));
        }
        MessageSelectorParser.doParse(element, builder);
        Element messageElement = DomUtils.getChildElementByTagName((Element)element, (String)"message");
        List<ValidationContext> validationContexts = this.parseValidationContexts(messageElement, builder);
        AbstractMessageContentBuilder messageBuilder = this.constructMessageBuilder(messageElement);
        this.parseHeaderElements(element, messageBuilder, validationContexts);
        builder.addPropertyValue("messageBuilder", (Object)messageBuilder);
        builder.addPropertyValue("validationContexts", validationContexts);
        builder.addPropertyValue("variableExtractors", this.getVariableExtractors(element));
        return builder.getBeanDefinition();
    }

    protected List<ValidationContext> parseValidationContexts(Element messageElement, BeanDefinitionBuilder builder) {
        ArrayList<ValidationContext> validationContexts = new ArrayList<ValidationContext>();
        if (messageElement != null) {
            String dataDictionary;
            String messageValidatorExpression;
            ScriptValidationContext scriptValidationContext;
            String headerValidatorExpression;
            String messageType = messageElement.getAttribute("type");
            if (!StringUtils.hasText((String)messageType)) {
                messageType = Citrus.DEFAULT_MESSAGE_TYPE;
            } else {
                builder.addPropertyValue("messageType", (Object)messageType);
            }
            HeaderValidationContext headerValidationContext = new HeaderValidationContext();
            validationContexts.add(headerValidationContext);
            String headerValidator = messageElement.getAttribute("header-validator");
            if (StringUtils.hasText((String)headerValidator)) {
                headerValidationContext.addHeaderValidator(headerValidator);
            }
            if (StringUtils.hasText((String)(headerValidatorExpression = messageElement.getAttribute("header-validators")))) {
                Stream.of(headerValidatorExpression.split(",")).map(String::trim).forEach(headerValidationContext::addHeaderValidator);
            }
            XmlMessageValidationContext xmlMessageValidationContext = this.getXmlMessageValidationContext(messageElement);
            validationContexts.add(xmlMessageValidationContext);
            XpathMessageValidationContext xPathMessageValidationContext = this.getXPathMessageValidationContext(messageElement, xmlMessageValidationContext);
            if (!xPathMessageValidationContext.getXpathExpressions().isEmpty()) {
                validationContexts.add(xPathMessageValidationContext);
            }
            JsonMessageValidationContext jsonMessageValidationContext = this.getJsonMessageValidationContext(messageElement);
            validationContexts.add(jsonMessageValidationContext);
            JsonPathMessageValidationContext jsonPathMessageValidationContext = this.getJsonPathMessageValidationContext(messageElement);
            if (!jsonPathMessageValidationContext.getJsonPathExpressions().isEmpty()) {
                validationContexts.add(jsonPathMessageValidationContext);
            }
            if ((scriptValidationContext = this.getScriptValidationContext(messageElement, messageType)) != null) {
                validationContexts.add(scriptValidationContext);
            }
            ManagedList validators = new ManagedList();
            String messageValidator = messageElement.getAttribute("validator");
            if (StringUtils.hasText((String)messageValidator)) {
                validators.add((Object)new RuntimeBeanReference(messageValidator));
            }
            if (StringUtils.hasText((String)(messageValidatorExpression = messageElement.getAttribute("validators")))) {
                Stream.of(messageValidatorExpression.split(",")).map(String::trim).map(RuntimeBeanReference::new).forEach(arg_0 -> validators.add(arg_0));
            }
            if (!validators.isEmpty()) {
                builder.addPropertyValue("validators", (Object)validators);
            }
            if (StringUtils.hasText((String)(dataDictionary = messageElement.getAttribute("data-dictionary")))) {
                builder.addPropertyReference("dataDictionary", dataDictionary);
            }
        } else {
            validationContexts.add(new HeaderValidationContext());
        }
        return validationContexts;
    }

    protected List<VariableExtractor> getVariableExtractors(Element element) {
        ArrayList<VariableExtractor> variableExtractors = new ArrayList<VariableExtractor>();
        this.parseExtractHeaderElements(element, variableExtractors);
        Element extractElement = DomUtils.getChildElementByTagName((Element)element, (String)"extract");
        if (extractElement != null) {
            HashMap<String, String> extractFromPath = new HashMap<String, String>();
            List messageValueElements = DomUtils.getChildElementsByTagName((Element)extractElement, (String)"message");
            messageValueElements.addAll(DomUtils.getChildElementsByTagName((Element)extractElement, (String)"body"));
            VariableExtractorParserUtil.parseMessageElement(messageValueElements, extractFromPath);
            if (!CollectionUtils.isEmpty(extractFromPath)) {
                VariableExtractorParserUtil.addPayloadVariableExtractors(element, variableExtractors, extractFromPath);
            }
        }
        return variableExtractors;
    }

    private JsonMessageValidationContext getJsonMessageValidationContext(Element messageElement) {
        JsonMessageValidationContext context = new JsonMessageValidationContext();
        if (messageElement != null) {
            HashSet<String> ignoreExpressions = new HashSet<String>();
            List ignoreElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"ignore");
            for (Element ignoreValue : ignoreElements) {
                ignoreExpressions.add(ignoreValue.getAttribute("path"));
            }
            context.setIgnoreExpressions(ignoreExpressions);
            this.addSchemaInformationToValidationContext(messageElement, context);
        }
        return context;
    }

    private XmlMessageValidationContext getXmlMessageValidationContext(Element messageElement) {
        XmlMessageValidationContext context = new XmlMessageValidationContext();
        if (messageElement != null) {
            this.addSchemaInformationToValidationContext(messageElement, context);
            HashSet<String> ignoreExpressions = new HashSet<String>();
            List ignoreElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"ignore");
            for (Element ignoreValue : ignoreElements) {
                ignoreExpressions.add(ignoreValue.getAttribute("path"));
            }
            context.setIgnoreExpressions(ignoreExpressions);
            this.parseNamespaceValidationElements(messageElement, context);
            HashMap<String, String> namespaces = new HashMap<String, String>();
            List namespaceElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"namespace");
            if (namespaceElements.size() > 0) {
                for (Element namespaceElement : namespaceElements) {
                    namespaces.put(namespaceElement.getAttribute("prefix"), namespaceElement.getAttribute("value"));
                }
                context.setNamespaces(namespaces);
            }
        }
        return context;
    }

    private void addSchemaInformationToValidationContext(Element messageElement, SchemaValidationContext context) {
        String schemaRepository;
        String schema;
        String schemaValidation = messageElement.getAttribute("schema-validation");
        if (StringUtils.hasText((String)schemaValidation)) {
            context.setSchemaValidation(Boolean.valueOf(schemaValidation));
        }
        if (StringUtils.hasText((String)(schema = messageElement.getAttribute("schema")))) {
            context.setSchema(schema);
        }
        if (StringUtils.hasText((String)(schemaRepository = messageElement.getAttribute("schema-repository")))) {
            context.setSchemaRepository(schemaRepository);
        }
    }

    private XpathMessageValidationContext getXPathMessageValidationContext(Element messageElement, XmlMessageValidationContext parentContext) {
        XpathMessageValidationContext context = new XpathMessageValidationContext();
        this.parseXPathValidationElements(messageElement, context);
        context.setControlNamespaces(parentContext.getControlNamespaces());
        context.setNamespaces(parentContext.getNamespaces());
        context.setIgnoreExpressions(parentContext.getIgnoreExpressions());
        context.setSchema(parentContext.getSchema());
        context.setSchemaRepository(parentContext.getSchemaRepository());
        context.setSchemaValidation(parentContext.isSchemaValidationEnabled());
        context.setDTDResource(parentContext.getDTDResource());
        return context;
    }

    private JsonPathMessageValidationContext getJsonPathMessageValidationContext(Element messageElement) {
        JsonPathMessageValidationContext context = new JsonPathMessageValidationContext();
        HashMap<String, Object> validateJsonPathExpressions = new HashMap<String, Object>();
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                this.extractJsonPathValidateExpressions(validateElement, validateJsonPathExpressions);
            }
            context.setJsonPathExpressions(validateJsonPathExpressions);
        }
        return context;
    }

    private ScriptValidationContext getScriptValidationContext(Element messageElement, String messageType) {
        ScriptValidationContext context = null;
        boolean done = false;
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                Element scriptElement = DomUtils.getChildElementByTagName((Element)validateElement, (String)"script");
                if (scriptElement == null) continue;
                if (done) {
                    throw new BeanCreationException("Found multiple validation script definitions - only supporting a single validation script for message validation");
                }
                done = true;
                context = new ScriptValidationContext(messageType);
                String type = scriptElement.getAttribute("type");
                context.setScriptType(type);
                String filePath = scriptElement.getAttribute("file");
                if (StringUtils.hasText((String)filePath)) {
                    context.setValidationScriptResourcePath(filePath);
                    if (!scriptElement.hasAttribute("charset")) continue;
                    context.setValidationScriptResourceCharset(scriptElement.getAttribute("charset"));
                    continue;
                }
                context.setValidationScript(DomUtils.getTextValue((Element)scriptElement));
            }
        }
        return context;
    }

    private void parseNamespaceValidationElements(Element messageElement, XmlMessageValidationContext context) {
        HashMap<String, String> validateNamespaces = new HashMap<String, String>();
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                List validateNamespaceElements = DomUtils.getChildElementsByTagName((Element)validateElement, (String)"namespace");
                if (validateNamespaceElements.size() <= 0) continue;
                for (Element namespaceElement : validateNamespaceElements) {
                    validateNamespaces.put(namespaceElement.getAttribute("prefix"), namespaceElement.getAttribute("value"));
                }
            }
            context.setControlNamespaces(validateNamespaces);
        }
    }

    private void parseXPathValidationElements(Element messageElement, XpathMessageValidationContext context) {
        HashMap<String, Object> validateXpathExpressions = new HashMap<String, Object>();
        List validateElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"validate");
        if (validateElements.size() > 0) {
            for (Element validateElement : validateElements) {
                this.extractXPathValidateExpressions(validateElement, validateXpathExpressions);
            }
            context.setXpathExpressions(validateXpathExpressions);
        }
    }

    private void extractXPathValidateExpressions(Element validateElement, Map<String, Object> validateXpathExpressions) {
        List xpathElements;
        String pathExpression = validateElement.getAttribute("path");
        if (StringUtils.hasText((String)pathExpression) && !JsonPathMessageValidationContext.isJsonPathExpression(pathExpression)) {
            if (validateElement.hasAttribute("result-type")) {
                pathExpression = validateElement.getAttribute("result-type") + ":" + pathExpression;
            }
            validateXpathExpressions.put(pathExpression, validateElement.getAttribute("value"));
        }
        if ((xpathElements = DomUtils.getChildElementsByTagName((Element)validateElement, (String)"xpath")).size() > 0) {
            for (Element xpathElement : xpathElements) {
                String expression = xpathElement.getAttribute("expression");
                if (!StringUtils.hasText((String)expression)) continue;
                if (xpathElement.hasAttribute("result-type")) {
                    expression = xpathElement.getAttribute("result-type") + ":" + expression;
                }
                validateXpathExpressions.put(expression, xpathElement.getAttribute("value"));
            }
        }
    }

    private void extractJsonPathValidateExpressions(Element validateElement, Map<String, Object> validateJsonPathExpressions) {
        String pathExpression = validateElement.getAttribute("path");
        if (JsonPathMessageValidationContext.isJsonPathExpression(pathExpression)) {
            validateJsonPathExpressions.put(pathExpression, validateElement.getAttribute("value"));
        }
        ValidateMessageParserUtil.parseJsonPathElements(validateElement, validateJsonPathExpressions);
    }

    protected BeanDefinitionBuilder parseComponent(Element element, ParserContext parserContext) {
        return BeanDefinitionBuilder.genericBeanDefinition(ReceiveMessageAction.class);
    }
}

