/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.xml.namespace.NamespaceContextBuilder;
import java.util.LinkedHashMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class NamespaceContextParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(NamespaceContextBuilder.class);
        this.parseNamespaceDefinitions(builder, element);
        parserContext.getRegistry().registerBeanDefinition("namespaceContextBuilder", (BeanDefinition)builder.getBeanDefinition());
        return null;
    }

    private void parseNamespaceDefinitions(BeanDefinitionBuilder builder, Element element) {
        LinkedHashMap<String, String> namespaces = new LinkedHashMap<String, String>();
        for (Element namespace : DomUtils.getChildElementsByTagName((Element)element, (String)"namespace")) {
            namespaces.put(namespace.getAttribute("prefix"), namespace.getAttribute("uri"));
        }
        if (!namespaces.isEmpty()) {
            builder.addPropertyValue("namespaceMappings", namespaces);
        }
    }
}

