/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.validation.MessageValidatorRegistry;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class MessageValidatorRegistryParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(MessageValidatorRegistry.class);
        this.parseValidators(builder, element);
        parserContext.getRegistry().registerBeanDefinition("citrusMessageValidatorRegistry", (BeanDefinition)builder.getBeanDefinition());
        return null;
    }

    private void parseValidators(BeanDefinitionBuilder builder, Element element) {
        ManagedList validators = new ManagedList();
        for (Element validator : DomUtils.getChildElementsByTagName((Element)element, (String)"validator")) {
            if (validator.hasAttribute("ref")) {
                validators.add((Object)new RuntimeBeanReference(validator.getAttribute("ref")));
                continue;
            }
            validators.add((Object)BeanDefinitionBuilder.rootBeanDefinition((String)validator.getAttribute("class")).getBeanDefinition());
        }
        if (!validators.isEmpty()) {
            builder.addPropertyValue("messageValidators", (Object)validators);
        }
    }
}

