/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.actions.JavaAction;
import com.consol.citrus.config.util.BeanDefinitionParserUtils;
import com.consol.citrus.config.xml.DescriptionElementParser;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public class JavaActionParser
implements BeanDefinitionParser {
    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder beanDefinition = BeanDefinitionBuilder.rootBeanDefinition(JavaAction.class);
        DescriptionElementParser.doParse(element, beanDefinition);
        BeanDefinitionParserUtils.setPropertyValue(beanDefinition, element.getAttribute("class"), "className");
        BeanDefinitionParserUtils.setPropertyReference(beanDefinition, element.getAttribute("ref"), "instance");
        Element constructorElement = DomUtils.getChildElementByTagName((Element)element, (String)"constructor");
        ArrayList<Object> arguments = new ArrayList<Object>();
        if (constructorElement != null) {
            List argumentList = DomUtils.getChildElementsByTagName((Element)constructorElement, (String)"argument");
            for (Element arg : argumentList) {
                arguments.add(this.resolveArgument(arg.getAttribute("type"), arg.getTextContent()));
            }
            beanDefinition.addPropertyValue("constructorArgs", arguments);
        }
        Element methodElement = DomUtils.getChildElementByTagName((Element)element, (String)"method");
        arguments = new ArrayList();
        if (methodElement != null) {
            String methodName = methodElement.getAttribute("name");
            beanDefinition.addPropertyValue("methodName", (Object)methodName);
            List argumentList = DomUtils.getChildElementsByTagName((Element)methodElement, (String)"argument");
            for (Element arg : argumentList) {
                arguments.add(this.resolveArgument(arg.getAttribute("type"), DomUtils.getTextValue((Element)arg)));
            }
            beanDefinition.addPropertyValue("methodArgs", arguments);
        }
        return beanDefinition.getBeanDefinition();
    }

    private Object resolveArgument(String type, String value) {
        if (!StringUtils.hasText((String)type) || type.equals("String")) {
            return value;
        }
        if (type.equals("String[]")) {
            return value.split(",");
        }
        if (type.equals("boolean")) {
            return (boolean)Boolean.valueOf(value);
        }
        if (type.equals("int")) {
            return (int)Integer.valueOf(value);
        }
        if (type.equals("long")) {
            return Long.valueOf(value);
        }
        if (type.equals("double")) {
            return Double.valueOf(value);
        }
        throw new BeanCreationException("Found unsupported method argument type: '" + type + "'");
    }
}

