/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.xml;

import com.consol.citrus.config.xml.PayloadElementParser;
import com.consol.citrus.message.MessageHeaderType;
import com.consol.citrus.validation.builder.AbstractMessageContentBuilder;
import com.consol.citrus.validation.builder.PayloadTemplateMessageBuilder;
import com.consol.citrus.validation.context.HeaderValidationContext;
import com.consol.citrus.validation.context.ValidationContext;
import com.consol.citrus.validation.interceptor.AbstractMessageConstructionInterceptor;
import com.consol.citrus.validation.json.JsonPathMessageConstructionInterceptor;
import com.consol.citrus.validation.json.JsonPathMessageValidationContext;
import com.consol.citrus.validation.script.GroovyScriptMessageBuilder;
import com.consol.citrus.validation.xml.XpathMessageConstructionInterceptor;
import com.consol.citrus.variable.MessageHeaderVariableExtractor;
import com.consol.citrus.variable.VariableExtractor;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;

public abstract class AbstractMessageActionParser
implements BeanDefinitionParser {
    public AbstractMessageContentBuilder constructMessageBuilder(Element messageElement) {
        AbstractMessageContentBuilder messageBuilder = null;
        if (messageElement != null && (messageBuilder = this.parsePayloadTemplateBuilder(messageElement)) == null) {
            messageBuilder = this.parseScriptBuilder(messageElement);
        }
        if (messageBuilder == null) {
            messageBuilder = new PayloadTemplateMessageBuilder();
        }
        if (messageElement != null && messageElement.hasAttribute("name")) {
            messageBuilder.setMessageName(messageElement.getAttribute("name"));
        }
        return messageBuilder;
    }

    private GroovyScriptMessageBuilder parseScriptBuilder(Element messageElement) {
        AbstractMessageContentBuilder scriptMessageBuilder = null;
        Element builderElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"builder");
        if (builderElement != null) {
            String builderType = builderElement.getAttribute("type");
            if (!StringUtils.hasText((String)builderType)) {
                throw new BeanCreationException("Missing message builder type - please define valid type attribute for message builder");
            }
            if (!builderType.equals("groovy")) {
                throw new BeanCreationException("Unsupported message builder type: '" + builderType + "'");
            }
            scriptMessageBuilder = new GroovyScriptMessageBuilder();
            String scriptResourcePath = builderElement.getAttribute("file");
            if (StringUtils.hasText((String)scriptResourcePath)) {
                ((GroovyScriptMessageBuilder)scriptMessageBuilder).setScriptResourcePath(scriptResourcePath);
                if (builderElement.hasAttribute("charset")) {
                    ((GroovyScriptMessageBuilder)scriptMessageBuilder).setScriptResourceCharset(builderElement.getAttribute("charset"));
                }
            } else {
                ((GroovyScriptMessageBuilder)scriptMessageBuilder).setScriptData(DomUtils.getTextValue((Element)builderElement).trim());
            }
        }
        if (scriptMessageBuilder != null && messageElement.hasAttribute("name")) {
            scriptMessageBuilder.setMessageName(messageElement.getAttribute("name"));
        }
        return scriptMessageBuilder;
    }

    private PayloadTemplateMessageBuilder parsePayloadTemplateBuilder(Element messageElement) {
        Element xmlResourceElement;
        PayloadTemplateMessageBuilder messageBuilder = this.parsePayloadElement(messageElement);
        Element xmlDataElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"data");
        if (xmlDataElement != null) {
            messageBuilder = new PayloadTemplateMessageBuilder();
            messageBuilder.setPayloadData(DomUtils.getTextValue((Element)xmlDataElement).trim());
        }
        if ((xmlResourceElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"resource")) != null) {
            messageBuilder = new PayloadTemplateMessageBuilder();
            messageBuilder.setPayloadResourcePath(xmlResourceElement.getAttribute("file"));
            if (xmlResourceElement.hasAttribute("charset")) {
                messageBuilder.setPayloadResourceCharset(xmlResourceElement.getAttribute("charset"));
            }
        }
        if (messageBuilder != null) {
            AbstractMessageConstructionInterceptor interceptor;
            HashMap<String, String> overwriteXpath = new HashMap<String, String>();
            HashMap<String, String> overwriteJsonPath = new HashMap<String, String>();
            List messageValueElements = DomUtils.getChildElementsByTagName((Element)messageElement, (String)"element");
            for (Element messageValue : messageValueElements) {
                String pathExpression = messageValue.getAttribute("path");
                if (JsonPathMessageValidationContext.isJsonPathExpression(pathExpression)) {
                    overwriteJsonPath.put(pathExpression, messageValue.getAttribute("value"));
                    continue;
                }
                overwriteXpath.put(pathExpression, messageValue.getAttribute("value"));
            }
            if (!overwriteXpath.isEmpty()) {
                interceptor = new XpathMessageConstructionInterceptor(overwriteXpath);
                messageBuilder.add(interceptor);
            }
            if (!overwriteJsonPath.isEmpty()) {
                interceptor = new JsonPathMessageConstructionInterceptor(overwriteJsonPath);
                messageBuilder.add(interceptor);
            }
        }
        return messageBuilder;
    }

    private PayloadTemplateMessageBuilder parsePayloadElement(Element messageElement) {
        PayloadTemplateMessageBuilder messageBuilder = null;
        Element payloadElement = DomUtils.getChildElementByTagName((Element)messageElement, (String)"payload");
        if (payloadElement != null) {
            List payload;
            messageBuilder = new PayloadTemplateMessageBuilder();
            if (messageElement.hasAttribute("name")) {
                messageBuilder.setMessageName(messageElement.getAttribute("name"));
            }
            if (CollectionUtils.isEmpty((Collection)(payload = DomUtils.getChildElements((Element)payloadElement)))) {
                messageBuilder.setPayloadData("");
            } else {
                messageBuilder.setPayloadData(PayloadElementParser.parseMessagePayload((Element)payload.get(0)));
            }
        }
        return messageBuilder;
    }

    protected void parseHeaderElements(Element actionElement, AbstractMessageContentBuilder messageBuilder, List<ValidationContext> validationContexts) {
        Element headerElement = DomUtils.getChildElementByTagName((Element)actionElement, (String)"header");
        LinkedHashMap<String, Object> messageHeaders = new LinkedHashMap<String, Object>();
        if (headerElement != null) {
            List elements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"element");
            for (Object headerValue : elements) {
                String name = headerValue.getAttribute("name");
                String value = headerValue.getAttribute("value");
                String type = headerValue.getAttribute("type");
                if (StringUtils.hasText((String)type)) {
                    value = MessageHeaderType.createTypedValue(type, value);
                }
                messageHeaders.put(name, value);
            }
            List headerDataElements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"data");
            for (Object headerDataElement : headerDataElements) {
                messageBuilder.getHeaderData().add(DomUtils.getTextValue((Element)headerDataElement).trim());
            }
            List headerResourceElements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"resource");
            for (Object headerResourceElement : headerResourceElements) {
                String charset = headerResourceElement.getAttribute("charset");
                messageBuilder.getHeaderResources().add(headerResourceElement.getAttribute("file") + (StringUtils.hasText((String)charset) ? ";charset=" + charset : ""));
            }
            List headerFragmentElements = DomUtils.getChildElementsByTagName((Element)headerElement, (String)"fragment");
            for (Element headerFragmentElement : headerFragmentElements) {
                List fragment = DomUtils.getChildElements((Element)headerFragmentElement);
                if (CollectionUtils.isEmpty((Collection)fragment)) continue;
                messageBuilder.getHeaderData().add(PayloadElementParser.parseMessagePayload((Element)fragment.get(0)));
            }
            messageBuilder.setMessageHeaders(messageHeaders);
            if (headerElement.hasAttribute("ignore-case")) {
                boolean ignoreCase = Boolean.valueOf(headerElement.getAttribute("ignore-case"));
                validationContexts.stream().filter(context -> context instanceof HeaderValidationContext).map(context -> (HeaderValidationContext)context).forEach(context -> context.setHeaderNameIgnoreCase(ignoreCase));
            }
        }
    }

    protected void parseExtractHeaderElements(Element element, List<VariableExtractor> variableExtractors) {
        Element extractElement = DomUtils.getChildElementByTagName((Element)element, (String)"extract");
        HashMap<String, String> extractHeaderValues = new HashMap<String, String>();
        if (extractElement != null) {
            List headerValueElements = DomUtils.getChildElementsByTagName((Element)extractElement, (String)"header");
            for (Element headerValue : headerValueElements) {
                extractHeaderValues.put(headerValue.getAttribute("name"), headerValue.getAttribute("variable"));
            }
            MessageHeaderVariableExtractor headerVariableExtractor = new MessageHeaderVariableExtractor();
            headerVariableExtractor.setHeaderMappings(extractHeaderValues);
            if (!CollectionUtils.isEmpty(extractHeaderValues)) {
                variableExtractors.add(headerVariableExtractor);
            }
        }
    }
}

