/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.config.annotation;

import com.consol.citrus.TestActor;
import com.consol.citrus.channel.ChannelMessageConverter;
import com.consol.citrus.channel.ChannelSyncEndpoint;
import com.consol.citrus.channel.ChannelSyncEndpointBuilder;
import com.consol.citrus.config.annotation.AbstractAnnotationConfigParser;
import com.consol.citrus.config.annotation.ChannelSyncEndpointConfig;
import com.consol.citrus.context.ReferenceResolver;
import com.consol.citrus.message.MessageCorrelator;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.core.DestinationResolver;
import org.springframework.util.StringUtils;

public class ChannelSyncEndpointConfigParser
extends AbstractAnnotationConfigParser<ChannelSyncEndpointConfig, ChannelSyncEndpoint> {
    public ChannelSyncEndpointConfigParser(ReferenceResolver referenceResolver) {
        super(referenceResolver);
    }

    @Override
    public ChannelSyncEndpoint parse(ChannelSyncEndpointConfig annotation) {
        ChannelSyncEndpointBuilder builder = new ChannelSyncEndpointBuilder();
        String channel = annotation.channel();
        String channelName = annotation.channelName();
        if (StringUtils.hasText((String)channel)) {
            builder.channel(this.getReferenceResolver().resolve(annotation.channel(), MessageChannel.class));
        }
        if (StringUtils.hasText((String)channelName)) {
            builder.channel(annotation.channelName());
        }
        if (StringUtils.hasText((String)annotation.messagingTemplate())) {
            String messagingTemplate = "messagingTemplate";
            if (StringUtils.hasText((String)annotation.messagingTemplate())) {
                messagingTemplate = annotation.messagingTemplate();
            }
            builder.messagingTemplate(this.getReferenceResolver().resolve(messagingTemplate, MessagingTemplate.class));
        }
        builder.useObjectMessages(annotation.useObjectMessages());
        if (StringUtils.hasText((String)annotation.messageConverter())) {
            builder.messageConverter(this.getReferenceResolver().resolve(annotation.messageConverter(), ChannelMessageConverter.class));
        }
        if (StringUtils.hasText((String)annotation.channelResolver())) {
            builder.channelResolver(this.getReferenceResolver().resolve(annotation.channelResolver(), DestinationResolver.class));
        }
        builder.timeout(annotation.timeout());
        if (StringUtils.hasText((String)annotation.actor())) {
            builder.actor(this.getReferenceResolver().resolve(annotation.actor(), TestActor.class));
        }
        if (StringUtils.hasText((String)annotation.correlator())) {
            builder.correlator(this.getReferenceResolver().resolve(annotation.correlator(), MessageCorrelator.class));
        }
        builder.pollingInterval(annotation.pollingInterval());
        return (ChannelSyncEndpoint)builder.initialize().build();
    }
}

