/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.condition;

import com.consol.citrus.condition.AbstractCondition;
import com.consol.citrus.context.TestContext;
import com.consol.citrus.util.FileUtils;
import java.io.File;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCondition
extends AbstractCondition {
    private String filePath;
    private File file;
    private static Logger log = LoggerFactory.getLogger(FileCondition.class);

    public FileCondition() {
        super("file-check");
    }

    @Override
    public boolean isSatisfied(TestContext context) {
        if (log.isDebugEnabled()) {
            log.debug(String.format("Checking file path '%s'", this.file != null ? this.file.getPath() : this.filePath));
        }
        if (this.file != null) {
            return this.file.exists() && this.file.isFile();
        }
        try {
            return FileUtils.getFileResource(context.replaceDynamicContentInString(this.filePath), context).getFile().isFile();
        }
        catch (IOException e) {
            log.warn(String.format("Failed to access file resource '%s'", e.getMessage()));
            return false;
        }
    }

    @Override
    public String getSuccessMessage(TestContext context) {
        return String.format("File condition success - file '%s' does exist", this.file != null ? this.file.getPath() : context.replaceDynamicContentInString(this.filePath));
    }

    @Override
    public String getErrorMessage(TestContext context) {
        return String.format("Failed to check file condition - file '%s' does not exist", this.file != null ? this.file.getPath() : context.replaceDynamicContentInString(this.filePath));
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }
}

