/*
 * Decompiled with CFR 0.152.
 */
package com.consol.citrus.condition;

import com.consol.citrus.TestAction;
import com.consol.citrus.condition.AbstractCondition;
import com.consol.citrus.context.TestContext;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActionCondition
extends AbstractCondition {
    private static Logger log = LoggerFactory.getLogger(ActionCondition.class);
    private TestAction action;
    private Exception caughtException;

    public ActionCondition() {
    }

    public ActionCondition(TestAction action) {
        this.action = action;
    }

    @Override
    public boolean isSatisfied(TestContext context) {
        if (this.action == null) {
            return false;
        }
        try {
            this.action.execute(context);
        }
        catch (Exception e) {
            this.caughtException = e;
            log.warn(String.format("Nested action did not perform as expected - %s", Optional.ofNullable(e.getMessage()).map(msg -> e.getClass().getName() + ": " + msg).orElse(e.getClass().getName())));
            return false;
        }
        return true;
    }

    @Override
    public String getSuccessMessage(TestContext context) {
        return String.format("Test action condition success - action '%s' did perform as expected", this.getActionName());
    }

    @Override
    public String getErrorMessage(TestContext context) {
        if (this.caughtException != null) {
            return String.format("Failed to check test action condition - action '%s' did not perform as expected: %s", this.getActionName(), Optional.ofNullable(this.caughtException.getMessage()).map(msg -> this.caughtException.getClass().getName() + ": " + msg).orElse(this.caughtException.getClass().getName()));
        }
        return String.format("Failed to check test action condition - action '%s' did not perform as expected", this.getActionName());
    }

    private String getActionName() {
        return Optional.ofNullable(this.action).map(TestAction::getName).orElse("unknown");
    }

    public TestAction getAction() {
        return this.action;
    }

    public void setAction(TestAction action) {
        this.action = action;
    }

    public Exception getCaughtException() {
        return this.caughtException;
    }

    public void setCaughtException(Exception caughtException) {
        this.caughtException = caughtException;
    }
}

